/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.vm.sa;

import java.lang.reflect.Method;
import org.openjdk.jol.util.ClassUtils;
import org.openjdk.jol.vm.sa.Task;
import org.openjdk.jol.vm.sa.UniverseData;

class UniverseTask
implements Task {
    UniverseTask() {
    }

    @Override
    public UniverseData process() {
        try {
            Class<?> universeClass = ClassUtils.loadClass("sun.jvm.hotspot.memory.Universe");
            Class<?> vmClass = ClassUtils.loadClass("sun.jvm.hotspot.runtime.VM");
            Method vmMethod = vmClass.getMethod("getVM", new Class[0]);
            Method heapOopSizeMethod = vmClass.getMethod("getHeapOopSize", new Class[0]);
            Method oopSizeMethod = vmClass.getMethod("getOopSize", new Class[0]);
            Method objectAlignmentMethod = vmClass.getMethod("getObjectAlignmentInBytes", new Class[0]);
            Method compOopsEnabledMethod = vmClass.getMethod("isCompressedOopsEnabled", new Class[0]);
            Method compKlassEnabledMethod = vmClass.getMethod("isCompressedKlassPointersEnabled", new Class[0]);
            Method narrowOopBaseMethod = null;
            Method narrowOopShiftMethod = null;
            try {
                Class<?> coopClass = ClassUtils.loadClass("sun.jvm.hotspot.oops.CompressedOops");
                narrowOopBaseMethod = coopClass.getMethod("getBase", new Class[0]);
                narrowOopShiftMethod = coopClass.getMethod("getShift", new Class[0]);
            }
            catch (Exception e) {
                narrowOopBaseMethod = universeClass.getMethod("getNarrowOopBase", new Class[0]);
                narrowOopShiftMethod = universeClass.getMethod("getNarrowOopShift", new Class[0]);
            }
            Method narrowKlassBaseMethod = null;
            Method narrowKlassShiftMethod = null;
            try {
                Class<?> coopClass = ClassUtils.loadClass("sun.jvm.hotspot.oops.CompressedKlassPointers");
                narrowKlassBaseMethod = coopClass.getMethod("getBase", new Class[0]);
                narrowKlassShiftMethod = coopClass.getMethod("getShift", new Class[0]);
            }
            catch (Exception e) {
                narrowKlassBaseMethod = universeClass.getMethod("getNarrowKlassBase", new Class[0]);
                narrowKlassShiftMethod = universeClass.getMethod("getNarrowKlassShift", new Class[0]);
            }
            Object vm = vmMethod.invoke(null, new Object[0]);
            return new UniverseData(((Long)oopSizeMethod.invoke(vm, new Object[0])).intValue(), (Integer)objectAlignmentMethod.invoke(vm, new Object[0]), (Integer)heapOopSizeMethod.invoke(vm, new Object[0]), (Boolean)compOopsEnabledMethod.invoke(vm, new Object[0]), (Long)narrowOopBaseMethod.invoke(null, new Object[0]), (Integer)narrowOopShiftMethod.invoke(null, new Object[0]), (Boolean)compKlassEnabledMethod.invoke(vm, new Object[0]), (Long)narrowKlassBaseMethod.invoke(null, new Object[0]), (Integer)narrowKlassShiftMethod.invoke(null, new Object[0]));
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage(), t);
        }
    }
}

