/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.tracing;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.filesystem.tracing.FileSystemAttributes;
import io.trino.filesystem.tracing.Tracing;
import io.trino.memory.context.AggregatedMemoryContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;

final class TracingOutputFile
implements TrinoOutputFile {
    private final Tracer tracer;
    private final TrinoOutputFile delegate;

    public TracingOutputFile(Tracer tracer, TrinoOutputFile delegate) {
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
        this.delegate = Objects.requireNonNull(delegate, "delete is null");
    }

    @Override
    public OutputStream create() throws IOException {
        Span span = this.tracer.spanBuilder("OutputFile.create").setAttribute(FileSystemAttributes.FILE_LOCATION, (Object)this.toString()).startSpan();
        return Tracing.withTracing(span, () -> this.delegate.create());
    }

    @Override
    public void createOrOverwrite(byte[] data) throws IOException {
        Span span = this.tracer.spanBuilder("OutputFile.createOrOverwrite").setAttribute(FileSystemAttributes.FILE_LOCATION, (Object)this.toString()).startSpan();
        Tracing.withTracing(span, () -> this.delegate.createOrOverwrite(data));
    }

    @Override
    public void createExclusive(byte[] data) throws IOException {
        Span span = this.tracer.spanBuilder("OutputFile.createExclusive").setAttribute(FileSystemAttributes.FILE_LOCATION, (Object)this.toString()).startSpan();
        Tracing.withTracing(span, () -> this.delegate.createExclusive(data));
    }

    @Override
    public OutputStream create(AggregatedMemoryContext memoryContext) throws IOException {
        Span span = this.tracer.spanBuilder("OutputFile.create").setAttribute(FileSystemAttributes.FILE_LOCATION, (Object)this.toString()).startSpan();
        return Tracing.withTracing(span, () -> this.delegate.create(memoryContext));
    }

    @Override
    public Location location() {
        return this.delegate.location();
    }

    public String toString() {
        return this.location().toString();
    }
}

