/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.AbstractLogger;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogContext;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLoggingApi;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.backend.LoggerBackend;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.backend.Platform;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.util.Checks;
import com.google.errorprone.annotations.CheckReturnValue;
import java.util.logging.Level;

@CheckReturnValue
public final class GoogleLogger
extends AbstractLogger<Api> {
    private static final NoOp NO_OP = new NoOp();

    public static GoogleLogger forEnclosingClass() {
        String loggingClass = Platform.getCallerFinder().findLoggingClass(GoogleLogger.class);
        return new GoogleLogger(Platform.getBackend(loggingClass));
    }

    @Deprecated
    public static GoogleLogger forInjectedClassName(String className) {
        Checks.checkArgument(!className.isEmpty(), "injected class name is empty");
        return new GoogleLogger(Platform.getBackend(className.replace('/', '.')));
    }

    GoogleLogger(LoggerBackend loggerBackend) {
        super(loggerBackend);
    }

    @Override
    public Api at(Level level) {
        boolean isLoggable = this.isLoggable(level);
        boolean isForced = Platform.shouldForceLogging(this.getName(), level, isLoggable);
        if (isLoggable || isForced) {
            return this.newContext(level, isForced);
        }
        return NO_OP;
    }

    private Context newContext(Level level, boolean isForced) {
        return new Context(level, isForced);
    }

    private final class Context
    extends GoogleLogContext<GoogleLogger, Api>
    implements Api {
        Context(Level level, boolean isForced) {
            super(level, isForced);
        }

        @Override
        protected GoogleLogger getLogger() {
            return GoogleLogger.this;
        }

        @Override
        protected Api api() {
            return this;
        }

        @Override
        protected Api noOp() {
            return NO_OP;
        }
    }

    private static final class NoOp
    extends GoogleLoggingApi.NoOp<Api>
    implements Api {
        private NoOp() {
        }
    }

    public static interface Api
    extends GoogleLoggingApi<Api> {
    }
}

