/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializedInvoker {
    private static final Logger LOG = LoggerFactory.getLogger(SerializedInvoker.class);
    private final AtomicReference<Link> _tail = new AtomicReference();
    private final String _name;
    private volatile Thread _invokerThread;

    public SerializedInvoker() {
        this("anonymous");
    }

    public SerializedInvoker(Class<?> nameFrom) {
        this(nameFrom.getSimpleName());
    }

    public SerializedInvoker(String name) {
        this._name = name;
    }

    boolean isCurrentThreadInvoking() {
        return this._invokerThread == Thread.currentThread();
    }

    public void assertCurrentThreadInvoking() throws IllegalStateException {
        if (!this.isCurrentThreadInvoking()) {
            throw new IllegalStateException();
        }
    }

    public Runnable offer(Runnable task) {
        Link penultimate;
        if (task == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Offering task null, skipping it in {}", (Object)this);
            }
            return null;
        }
        if (NamedRunnable.LOG.isDebugEnabled() && !(task instanceof NamedRunnable)) {
            task = new NamedRunnable(task);
        }
        Link link = new Link(task);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Offering link {} of {}", (Object)link, (Object)this);
        }
        if ((penultimate = this._tail.getAndSet(link)) == null) {
            return link;
        }
        penultimate._next.lazySet(link);
        return null;
    }

    public Runnable offer(Runnable ... tasks) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Offering {} tasks in {}", (Object)tasks.length, (Object)this);
        }
        Runnable runnable = null;
        for (Runnable task : tasks) {
            if (runnable == null) {
                runnable = this.offer(task);
                continue;
            }
            this.offer(task);
        }
        return runnable;
    }

    public void run(Runnable task) {
        Runnable todo = this.offer(task);
        if (todo != null) {
            todo.run();
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Queued link in {}", (Object)this);
        }
    }

    public void run(Runnable ... tasks) {
        Runnable todo = this.offer(tasks);
        if (todo != null) {
            todo.run();
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Queued links in {}", (Object)this);
        }
    }

    public String toString() {
        return String.format("%s@%x{name=%s,tail=%s,invoker=%s}", this.getClass().getSimpleName(), this.hashCode(), this._name, this._tail, this._invokerThread);
    }

    protected void onError(Runnable task, Throwable t) {
        LOG.warn("Serialized invocation error", t);
    }

    private class NamedRunnable
    implements Runnable {
        private static final Logger LOG = LoggerFactory.getLogger(NamedRunnable.class);
        private final Runnable delegate;
        private final String name;
        private final Throwable stack;

        private NamedRunnable(Runnable delegate) {
            this.delegate = delegate;
            this.stack = new Throwable();
            this.name = this.deriveTaskName(delegate, this.stack);
        }

        private String deriveTaskName(Runnable task, Throwable stack) {
            StackTraceElement[] stackTrace;
            for (StackTraceElement stackTraceElement : stackTrace = stack.getStackTrace()) {
                String className = stackTraceElement.getClassName();
                if (className.equals(SerializedInvoker.class.getName()) || className.equals(SerializedInvoker.this.getClass().getName()) || className.equals(this.getClass().getName())) continue;
                return "Queued by " + Thread.currentThread().getName() + " at " + String.valueOf(stackTraceElement);
            }
            return task.toString();
        }

        @Override
        public void run() {
            this.delegate.run();
        }

        public String toString() {
            return this.name;
        }
    }

    private class Link
    implements Runnable,
    Invocable,
    Dumpable {
        private final Runnable _task;
        private final AtomicReference<Link> _next = new AtomicReference();

        public Link(Runnable task) {
            this._task = task;
        }

        @Override
        public void dump(Appendable out, String indent) throws IOException {
            Runnable runnable = this._task;
            if (runnable instanceof NamedRunnable) {
                NamedRunnable nr = (NamedRunnable)runnable;
                StringWriter sw = new StringWriter();
                nr.stack.printStackTrace(new PrintWriter(sw));
                Dumpable.dumpObjects(out, indent, nr.toString(), sw.toString());
            } else {
                Dumpable.dumpObjects(out, indent, this._task, new Object[0]);
            }
            Link link = this._next.get();
            if (link != null) {
                link.dump(out, indent);
            }
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.BLOCKING;
        }

        Link next() {
            if (SerializedInvoker.this._tail.compareAndSet(this, null)) {
                return null;
            }
            Link next;
            while ((next = this._next.get()) == null) {
                Thread.onSpinWait();
            }
            return next;
        }

        @Override
        public void run() {
            Link link = this;
            while (link != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Running link {} of {}", (Object)link, (Object)SerializedInvoker.this);
                }
                SerializedInvoker.this._invokerThread = Thread.currentThread();
                try {
                    link._task.run();
                }
                catch (Throwable t) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Failed while running link {} of {}", new Object[]{link, SerializedInvoker.this, t});
                    }
                    SerializedInvoker.this.onError(link._task, t);
                }
                finally {
                    SerializedInvoker.this._invokerThread = null;
                }
                if ((link = link.next()) != null || !LOG.isDebugEnabled()) continue;
                LOG.debug("Next link is null, execution is over in {}", (Object)SerializedInvoker.this);
            }
        }

        public String toString() {
            return String.format("%s@%x{%s -> %s}", this.getClass().getSimpleName(), this.hashCode(), this._task, this._next);
        }
    }
}

