/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.util.InvalidChecksumSizeException;
import org.apache.hadoop.util.NativeCrc32;
import org.apache.hadoop.util.PureJavaCrc32C;
import org.apache.hadoop.util.Shell;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class DataChecksum
implements Checksum {
    public static final int CHECKSUM_NULL = 0;
    public static final int CHECKSUM_CRC32 = 1;
    public static final int CHECKSUM_CRC32C = 2;
    public static final int CHECKSUM_DEFAULT = 3;
    public static final int CHECKSUM_MIXED = 4;
    private static final Logger LOG = LoggerFactory.getLogger(DataChecksum.class);
    private static volatile boolean useJava9Crc32C = Shell.isJavaVersionAtLeast(9);
    private final Type type;
    private final Checksum summer;
    private final int bytesPerChecksum;
    private int inSum = 0;
    public static final int SIZE_OF_INTEGER = 4;

    public static Checksum newCrc32() {
        return new CRC32();
    }

    static Checksum newCrc32C() {
        try {
            return useJava9Crc32C ? Java9Crc32CFactory.createChecksum() : new PureJavaCrc32C();
        }
        catch (ExceptionInInitializerError | RuntimeException e) {
            LOG.error("CRC32C creation failed, switching to PureJavaCrc32C", e);
            useJava9Crc32C = false;
            return new PureJavaCrc32C();
        }
    }

    public static int getCrcPolynomialForType(Type type) throws IOException {
        switch (type) {
            case CRC32: {
                return -306674912;
            }
            case CRC32C: {
                return -2097792136;
            }
        }
        throw new IOException("No CRC polynomial could be associated with type: " + (Object)((Object)type));
    }

    public static DataChecksum newDataChecksum(Type type, int bytesPerChecksum) {
        if (bytesPerChecksum <= 0) {
            return null;
        }
        switch (type) {
            case NULL: {
                return new DataChecksum(type, new ChecksumNull(), bytesPerChecksum);
            }
            case CRC32: {
                return new DataChecksum(type, DataChecksum.newCrc32(), bytesPerChecksum);
            }
            case CRC32C: {
                return new DataChecksum(type, DataChecksum.newCrc32C(), bytesPerChecksum);
            }
        }
        return null;
    }

    public static DataChecksum newDataChecksum(byte[] bytes, int offset) throws IOException {
        if (offset < 0 || bytes.length < offset + DataChecksum.getChecksumHeaderSize()) {
            throw new InvalidChecksumSizeException("Could not create DataChecksum  from the byte array of length " + bytes.length + " and offset " + offset);
        }
        int bytesPerChecksum = (bytes[offset + 1] & 0xFF) << 24 | (bytes[offset + 2] & 0xFF) << 16 | (bytes[offset + 3] & 0xFF) << 8 | bytes[offset + 4] & 0xFF;
        DataChecksum csum = DataChecksum.newDataChecksum(DataChecksum.mapByteToChecksumType(bytes[offset]), bytesPerChecksum);
        if (csum == null) {
            throw new InvalidChecksumSizeException("Could not create DataChecksum  from the byte array of length " + bytes.length + " and bytesPerCheckSum of " + bytesPerChecksum);
        }
        return csum;
    }

    public static DataChecksum newDataChecksum(DataInputStream in) throws IOException {
        byte type = in.readByte();
        int bpc = in.readInt();
        DataChecksum summer = DataChecksum.newDataChecksum(DataChecksum.mapByteToChecksumType(type), bpc);
        if (summer == null) {
            throw new InvalidChecksumSizeException("Could not create DataChecksum of type " + type + " with bytesPerChecksum " + bpc);
        }
        return summer;
    }

    private static Type mapByteToChecksumType(int type) throws InvalidChecksumSizeException {
        try {
            return Type.valueOf(type);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidChecksumSizeException("The value " + type + " does not map to a valid checksum Type");
        }
    }

    public void writeHeader(DataOutputStream out) throws IOException {
        out.writeByte(this.type.id);
        out.writeInt(this.bytesPerChecksum);
    }

    public byte[] getHeader() {
        byte[] header = new byte[DataChecksum.getChecksumHeaderSize()];
        header[0] = (byte)(this.type.id & 0xFF);
        header[1] = (byte)(this.bytesPerChecksum >>> 24 & 0xFF);
        header[2] = (byte)(this.bytesPerChecksum >>> 16 & 0xFF);
        header[3] = (byte)(this.bytesPerChecksum >>> 8 & 0xFF);
        header[4] = (byte)(this.bytesPerChecksum & 0xFF);
        return header;
    }

    public int writeValue(DataOutputStream out, boolean reset) throws IOException {
        if (this.type.size <= 0) {
            return 0;
        }
        if (this.type.size != 4) {
            throw new IOException("Unknown Checksum " + (Object)((Object)this.type));
        }
        out.writeInt((int)this.summer.getValue());
        if (reset) {
            this.reset();
        }
        return this.type.size;
    }

    public int writeValue(byte[] buf, int offset, boolean reset) throws IOException {
        if (this.type.size <= 0) {
            return 0;
        }
        if (this.type.size != 4) {
            throw new IOException("Unknown Checksum " + (Object)((Object)this.type));
        }
        int checksum = (int)this.summer.getValue();
        buf[offset + 0] = (byte)(checksum >>> 24 & 0xFF);
        buf[offset + 1] = (byte)(checksum >>> 16 & 0xFF);
        buf[offset + 2] = (byte)(checksum >>> 8 & 0xFF);
        buf[offset + 3] = (byte)(checksum & 0xFF);
        if (reset) {
            this.reset();
        }
        return this.type.size;
    }

    public boolean compare(byte[] buf, int offset) {
        if (this.type.size == 4) {
            int checksum = (buf[offset + 0] & 0xFF) << 24 | (buf[offset + 1] & 0xFF) << 16 | (buf[offset + 2] & 0xFF) << 8 | buf[offset + 3] & 0xFF;
            return checksum == (int)this.summer.getValue();
        }
        return this.type.size == 0;
    }

    private DataChecksum(Type type, Checksum checksum, int chunkSize) {
        this.type = type;
        this.summer = checksum;
        this.bytesPerChecksum = chunkSize;
    }

    public Type getChecksumType() {
        return this.type;
    }

    public int getChecksumSize() {
        return this.type.size;
    }

    public int getChecksumSize(int dataSize) {
        return ((dataSize - 1) / this.getBytesPerChecksum() + 1) * this.getChecksumSize();
    }

    public int getBytesPerChecksum() {
        return this.bytesPerChecksum;
    }

    public int getNumBytesInSum() {
        return this.inSum;
    }

    public static int getChecksumHeaderSize() {
        return 5;
    }

    @Override
    public long getValue() {
        return this.summer.getValue();
    }

    @Override
    public void reset() {
        this.summer.reset();
        this.inSum = 0;
    }

    @Override
    public void update(byte[] b, int off, int len) {
        if (len > 0) {
            this.summer.update(b, off, len);
            this.inSum += len;
        }
    }

    @Override
    public void update(int b) {
        this.summer.update(b);
        ++this.inSum;
    }

    public void verifyChunkedSums(ByteBuffer data, ByteBuffer checksums, String fileName, long basePos) throws ChecksumException {
        if (this.type.size == 0) {
            return;
        }
        if (data.hasArray() && checksums.hasArray()) {
            int dataOffset = data.arrayOffset() + data.position();
            int crcsOffset = checksums.arrayOffset() + checksums.position();
            if (NativeCrc32.isAvailable()) {
                NativeCrc32.verifyChunkedSumsByteArray(this.bytesPerChecksum, this.type.id, checksums.array(), crcsOffset, data.array(), dataOffset, data.remaining(), fileName, basePos);
            } else {
                DataChecksum.verifyChunked(this.type, this.summer, data.array(), dataOffset, data.remaining(), this.bytesPerChecksum, checksums.array(), crcsOffset, fileName, basePos);
            }
            return;
        }
        if (NativeCrc32.isAvailable() && data.isDirect()) {
            NativeCrc32.verifyChunkedSums(this.bytesPerChecksum, this.type.id, checksums, data, fileName, basePos);
        } else {
            DataChecksum.verifyChunked(this.type, this.summer, data, this.bytesPerChecksum, checksums, fileName, basePos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void verifyChunked(Type type, Checksum algorithm, ByteBuffer data, int bytesPerCrc, ByteBuffer crcs, String filename, long basePos) throws ChecksumException {
        byte[] bytes = new byte[bytesPerCrc];
        int dataOffset = data.position();
        int dataLength = data.remaining();
        data.mark();
        crcs.mark();
        try {
            long errPos;
            int expected;
            int computed;
            int i;
            int n = dataLength - bytesPerCrc + 1;
            for (i = 0; i < n; i += bytesPerCrc) {
                data.get(bytes);
                algorithm.reset();
                algorithm.update(bytes, 0, bytesPerCrc);
                computed = (int)algorithm.getValue();
                expected = crcs.getInt();
                if (computed == expected) continue;
                errPos = basePos + (long)data.position() - (long)dataOffset - (long)bytesPerCrc;
                DataChecksum.throwChecksumException(type, algorithm, filename, errPos, expected, computed);
            }
            int remainder = dataLength - i;
            if (remainder > 0) {
                data.get(bytes, 0, remainder);
                algorithm.reset();
                algorithm.update(bytes, 0, remainder);
                computed = (int)algorithm.getValue();
                expected = crcs.getInt();
                if (computed != expected) {
                    errPos = basePos + (long)data.position() - (long)dataOffset - (long)remainder;
                    DataChecksum.throwChecksumException(type, algorithm, filename, errPos, expected, computed);
                }
            }
        }
        finally {
            data.reset();
            crcs.reset();
        }
    }

    static void verifyChunked(Type type, Checksum algorithm, byte[] data, int dataOffset, int dataLength, int bytesPerCrc, byte[] crcs, int crcsOffset, String filename, long basePos) throws ChecksumException {
        long errPos;
        int expected;
        int computed;
        int dataEnd = dataOffset + dataLength;
        int i = dataOffset;
        int j = crcsOffset;
        int n = dataEnd - bytesPerCrc + 1;
        while (i < n) {
            algorithm.reset();
            algorithm.update(data, i, bytesPerCrc);
            computed = (int)algorithm.getValue();
            expected = (crcs[j] << 24) + (crcs[j + 1] << 24 >>> 8) + ((crcs[j + 2] << 24 >>> 16) + (crcs[j + 3] << 24 >>> 24));
            if (computed != expected) {
                errPos = basePos + (long)i - (long)dataOffset;
                DataChecksum.throwChecksumException(type, algorithm, filename, errPos, expected, computed);
            }
            i += bytesPerCrc;
            j += 4;
        }
        int remainder = dataEnd - i;
        if (remainder > 0) {
            algorithm.reset();
            algorithm.update(data, i, remainder);
            computed = (int)algorithm.getValue();
            expected = (crcs[j] << 24) + (crcs[j + 1] << 24 >>> 8) + ((crcs[j + 2] << 24 >>> 16) + (crcs[j + 3] << 24 >>> 24));
            if (computed != expected) {
                errPos = basePos + (long)i - (long)dataOffset;
                DataChecksum.throwChecksumException(type, algorithm, filename, errPos, expected, computed);
            }
        }
    }

    private static void throwChecksumException(Type type, Checksum algorithm, String filename, long errPos, int expected, int computed) throws ChecksumException {
        throw new ChecksumException("Checksum " + (Object)((Object)type) + " not matched for file " + filename + " at position " + errPos + String.format(": expected=%X but computed=%X", expected, computed) + ", algorithm=" + algorithm.getClass().getSimpleName(), errPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateChunkedSums(ByteBuffer data, ByteBuffer checksums) {
        if (this.type.size == 0) {
            return;
        }
        if (data.hasArray() && checksums.hasArray()) {
            this.calculateChunkedSums(data.array(), data.arrayOffset() + data.position(), data.remaining(), checksums.array(), checksums.arrayOffset() + checksums.position());
            return;
        }
        if (NativeCrc32.isAvailable()) {
            NativeCrc32.calculateChunkedSums(this.bytesPerChecksum, this.type.id, checksums, data);
            return;
        }
        data.mark();
        checksums.mark();
        try {
            byte[] buf = new byte[this.bytesPerChecksum];
            while (data.remaining() > 0) {
                int n = Math.min(data.remaining(), this.bytesPerChecksum);
                data.get(buf, 0, n);
                this.summer.reset();
                this.summer.update(buf, 0, n);
                checksums.putInt((int)this.summer.getValue());
            }
        }
        finally {
            data.reset();
            checksums.reset();
        }
    }

    public void calculateChunkedSums(byte[] data, int dataOffset, int dataLength, byte[] sums, int sumsOffset) {
        int n;
        if (this.type.size == 0) {
            return;
        }
        if (NativeCrc32.isAvailable()) {
            NativeCrc32.calculateChunkedSumsByteArray(this.bytesPerChecksum, this.type.id, sums, sumsOffset, data, dataOffset, dataLength);
            return;
        }
        for (int remaining = dataLength; remaining > 0; remaining -= n) {
            n = Math.min(remaining, this.bytesPerChecksum);
            this.summer.reset();
            this.summer.update(data, dataOffset, n);
            dataOffset += n;
            long calculated = this.summer.getValue();
            sums[sumsOffset++] = (byte)(calculated >> 24);
            sums[sumsOffset++] = (byte)(calculated >> 16);
            sums[sumsOffset++] = (byte)(calculated >> 8);
            sums[sumsOffset++] = (byte)calculated;
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof DataChecksum)) {
            return false;
        }
        DataChecksum o = (DataChecksum)other;
        return o.bytesPerChecksum == this.bytesPerChecksum && o.type == this.type;
    }

    public int hashCode() {
        return (this.type.id + 31) * this.bytesPerChecksum;
    }

    public String toString() {
        return "DataChecksum(type=" + (Object)((Object)this.type) + ", chunkSize=" + this.bytesPerChecksum + ")";
    }

    private static class Java9Crc32CFactory {
        private static final MethodHandle NEW_CRC32C_MH;

        private Java9Crc32CFactory() {
        }

        public static Checksum createChecksum() {
            try {
                return NEW_CRC32C_MH.invoke();
            }
            catch (Throwable t) {
                throw t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
            }
        }

        static {
            MethodHandle newCRC32C = null;
            try {
                newCRC32C = MethodHandles.publicLookup().findConstructor(Class.forName("java.util.zip.CRC32C"), MethodType.methodType(Void.TYPE));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
            NEW_CRC32C_MH = newCRC32C;
        }
    }

    static class ChecksumNull
    implements Checksum {
        @Override
        public long getValue() {
            return 0L;
        }

        @Override
        public void reset() {
        }

        @Override
        public void update(byte[] b, int off, int len) {
        }

        @Override
        public void update(int b) {
        }
    }

    public static enum Type {
        NULL(0, 0),
        CRC32(1, 4),
        CRC32C(2, 4),
        DEFAULT(3, 0),
        MIXED(4, 0);

        public final int id;
        public final int size;

        private Type(int id, int size) {
            this.id = id;
            this.size = size;
        }

        public static Type valueOf(int id) {
            if (id < 0 || id >= Type.values().length) {
                throw new IllegalArgumentException("id=" + id + " out of range [0, " + Type.values().length + ")");
            }
            return Type.values()[id];
        }
    }
}

