/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.InodeTree;
import org.apache.hadoop.fs.viewfs.RegexMountPointInterceptor;
import org.apache.hadoop.fs.viewfs.RegexMountPointInterceptorFactory;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class RegexMountPoint<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegexMountPoint.class.getName());
    private InodeTree inodeTree;
    private String srcPathRegex;
    private Pattern srcPattern;
    private String dstPath;
    private String interceptorSettingsString;
    private List<RegexMountPointInterceptor> interceptorList;
    public static final String SETTING_SRCREGEX_SEP = "#.";
    public static final char INTERCEPTOR_SEP = ';';
    public static final char INTERCEPTOR_INTERNAL_SEP = ':';
    public static final Pattern VAR_PATTERN_IN_DEST = Pattern.compile("\\$((\\{\\w+\\})|(\\w+))");
    private Map<String, Set<String>> varInDestPathMap;

    public Map<String, Set<String>> getVarInDestPathMap() {
        return this.varInDestPathMap;
    }

    RegexMountPoint(InodeTree inodeTree, String sourcePathRegex, String destPath, String settingsStr) {
        this.inodeTree = inodeTree;
        this.srcPathRegex = sourcePathRegex;
        this.dstPath = destPath;
        this.interceptorSettingsString = settingsStr;
        this.interceptorList = new ArrayList<RegexMountPointInterceptor>();
    }

    public void initialize() throws IOException {
        try {
            this.srcPattern = Pattern.compile(this.srcPathRegex);
        }
        catch (PatternSyntaxException ex) {
            throw new IOException("Failed to initialized mount point due to bad src path regex:" + this.srcPathRegex + ", dstPath:" + this.dstPath, ex);
        }
        this.varInDestPathMap = RegexMountPoint.getVarListInString(this.dstPath);
        this.initializeInterceptors();
    }

    private void initializeInterceptors() throws IOException {
        String[] interceptorStrArray;
        if (this.interceptorSettingsString == null || this.interceptorSettingsString.isEmpty()) {
            return;
        }
        for (String interceptorStr : interceptorStrArray = StringUtils.split(this.interceptorSettingsString, ';')) {
            RegexMountPointInterceptor interceptor = RegexMountPointInterceptorFactory.create(interceptorStr);
            if (interceptor == null) {
                throw new IOException("Illegal settings String " + this.interceptorSettingsString);
            }
            interceptor.initialize();
            this.interceptorList.add(interceptor);
        }
    }

    public static Map<String, Set<String>> getVarListInString(String input) {
        HashMap<String, Set<String>> varMap = new HashMap<String, Set<String>>();
        Matcher matcher = VAR_PATTERN_IN_DEST.matcher(input);
        while (matcher.find()) {
            String varName = matcher.group(0);
            String strippedVarName = matcher.group(1);
            if (strippedVarName.startsWith("{")) {
                strippedVarName = strippedVarName.substring(1, strippedVarName.length() - 1);
            }
            varMap.putIfAbsent(strippedVarName, new HashSet());
            ((Set)varMap.get(strippedVarName)).add(varName);
        }
        return varMap;
    }

    public String getSrcPathRegex() {
        return this.srcPathRegex;
    }

    public Pattern getSrcPattern() {
        return this.srcPattern;
    }

    public String getDstPath() {
        return this.dstPath;
    }

    public static Pattern getVarPatternInDest() {
        return VAR_PATTERN_IN_DEST;
    }

    public InodeTree.ResolveResult<T> resolve(String srcPath, boolean resolveLastComponent) {
        String pathStrToResolve = this.getPathToResolve(srcPath, resolveLastComponent);
        for (RegexMountPointInterceptor interceptor : this.interceptorList) {
            pathStrToResolve = interceptor.interceptSource(pathStrToResolve);
        }
        LOGGER.debug("Path to resolve:" + pathStrToResolve + ", srcPattern:" + this.getSrcPathRegex());
        Matcher srcMatcher = this.getSrcPattern().matcher(pathStrToResolve);
        String parsedDestPath = this.getDstPath();
        int mappedCount = 0;
        String resolvedPathStr = "";
        while (srcMatcher.find()) {
            resolvedPathStr = pathStrToResolve.substring(0, srcMatcher.end());
            Map<String, Set<String>> varMap = this.getVarInDestPathMap();
            for (Map.Entry entry : varMap.entrySet()) {
                String regexGroupNameOrIndexStr = (String)entry.getKey();
                Set groupRepresentationStrSetInDest = (Set)entry.getValue();
                parsedDestPath = this.replaceRegexCaptureGroupInPath(parsedDestPath, srcMatcher, regexGroupNameOrIndexStr, groupRepresentationStrSetInDest);
            }
            ++mappedCount;
        }
        if (0 == mappedCount) {
            return null;
        }
        Path remainingPath = this.getRemainingPathStr(srcPath, resolvedPathStr);
        for (RegexMountPointInterceptor regexMountPointInterceptor : this.interceptorList) {
            parsedDestPath = regexMountPointInterceptor.interceptResolvedDestPathStr(parsedDestPath);
            remainingPath = regexMountPointInterceptor.interceptRemainingPath(remainingPath);
        }
        InodeTree.ResolveResult resolveResult = this.inodeTree.buildResolveResultForRegexMountPoint(InodeTree.ResultKind.EXTERNAL_DIR, resolvedPathStr, parsedDestPath, remainingPath);
        return resolveResult;
    }

    private Path getRemainingPathStr(String srcPath, String resolvedPathStr) {
        String remainingPathStr = srcPath.substring(resolvedPathStr.length());
        if (!remainingPathStr.startsWith("/")) {
            remainingPathStr = "/" + remainingPathStr;
        }
        return new Path(remainingPathStr);
    }

    private String getPathToResolve(String srcPath, boolean resolveLastComponent) {
        if (resolveLastComponent) {
            return srcPath;
        }
        int lastSlashIndex = srcPath.lastIndexOf(InodeTree.SlashPath.toString());
        if (lastSlashIndex == -1) {
            return null;
        }
        return srcPath.substring(0, lastSlashIndex);
    }

    private String replaceRegexCaptureGroupInPath(String parsedDestPath, Matcher srcMatcher, String regexGroupNameOrIndexStr, Set<String> groupRepresentationStrSetInDest) {
        String groupValue = this.getRegexGroupValueFromMather(srcMatcher, regexGroupNameOrIndexStr);
        if (groupValue == null) {
            return parsedDestPath;
        }
        for (String varName : groupRepresentationStrSetInDest) {
            parsedDestPath = parsedDestPath.replace(varName, groupValue);
            LOGGER.debug("parsedDestPath value is:" + parsedDestPath);
        }
        return parsedDestPath;
    }

    private String getRegexGroupValueFromMather(Matcher srcMatcher, String regexGroupNameOrIndexStr) {
        if (regexGroupNameOrIndexStr.matches("\\d+")) {
            int groupIndex = Integer.parseUnsignedInt(regexGroupNameOrIndexStr);
            if (groupIndex >= 0 && groupIndex <= srcMatcher.groupCount()) {
                return srcMatcher.group(groupIndex);
            }
        } else {
            return srcMatcher.group(regexGroupNameOrIndexStr);
        }
        return null;
    }
}

