/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.statistics.impl;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsAggregator;
import org.apache.hadoop.fs.statistics.IOStatisticsContext;
import org.apache.hadoop.fs.statistics.IOStatisticsSnapshot;

public final class IOStatisticsContextImpl
implements IOStatisticsContext {
    private static final Logger LOG = LoggerFactory.getLogger(IOStatisticsContextImpl.class);
    private final long threadId;
    private final long id;
    private final IOStatisticsSnapshot ioStatistics = new IOStatisticsSnapshot();

    public IOStatisticsContextImpl(long threadId, long id) {
        this.threadId = threadId;
        this.id = id;
    }

    public String toString() {
        return "IOStatisticsContextImpl{id=" + this.id + ", threadId=" + this.threadId + ", ioStatistics=" + this.ioStatistics + '}';
    }

    @Override
    public IOStatisticsAggregator getAggregator() {
        return this.ioStatistics;
    }

    @Override
    public IOStatisticsSnapshot snapshot() {
        LOG.debug("Taking snapshot of IOStatisticsContext id {}", (Object)this.id);
        return new IOStatisticsSnapshot(this.ioStatistics);
    }

    @Override
    public void reset() {
        LOG.debug("clearing IOStatisticsContext id {}", (Object)this.id);
        this.ioStatistics.clear();
    }

    @Override
    public IOStatistics getIOStatistics() {
        return this.ioStatistics;
    }

    @Override
    public long getID() {
        return this.id;
    }

    public long getThreadID() {
        return this.threadId;
    }
}

