/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.com.microsoft.azure.datalake.store;

import io.trino.hadoop.;

public class ADLStoreOptions {
    private String userAgentSuffix = null;
    private boolean insecureTransport = false;
    private boolean enableRemoteExceptions = false;
    private String pathPrefix = null;
    private int readAheadQueueDepth = -1;
    private int defaultTimeout = -1;
    private boolean alterCipherSuits = true;
    private .SSLSocketFactoryEx.SSLChannelMode sslChannelMode = .SSLSocketFactoryEx.SSLChannelMode.Default;
    private int maxRetries = 4;
    private int exponentialRetryInterval = 1000;
    private int exponentialFactor = 4;
    static final int DEFAULT_MAX_RETRIES = 4;
    static final int DEFAULT_EXPONENTIAL_RETRY_INTERVAL = 1000;
    static final int DEFAULT_EXPONENTIAL_FACTOR = 4;
    private boolean enableConditionalCreate = false;

    public ADLStoreOptions setUserAgentSuffix(String userAgentSuffix) {
        this.userAgentSuffix = userAgentSuffix;
        return this;
    }

    String getUserAgentSuffix() {
        return this.userAgentSuffix;
    }

    public ADLStoreOptions setInsecureTransport() {
        this.insecureTransport = true;
        return this;
    }

    boolean isUsingInsecureTransport() {
        return this.insecureTransport;
    }

    public ADLStoreOptions enableThrowingRemoteExceptions() {
        this.enableRemoteExceptions = true;
        return this;
    }

    boolean isThrowingRemoteExceptionsEnabled() {
        return this.enableRemoteExceptions;
    }

    public ADLStoreOptions setFilePathPrefix(String prefix) {
        this.pathPrefix = prefix;
        return this;
    }

    String getFilePathPrefix() {
        return this.pathPrefix;
    }

    public ADLStoreOptions setReadAheadQueueDepth(int queueDepth) {
        if (queueDepth < 0) {
            throw new IllegalArgumentException("Queue depth has to be 0 or more");
        }
        this.readAheadQueueDepth = queueDepth;
        return this;
    }

    int getReadAheadQueueDepth() {
        return this.readAheadQueueDepth;
    }

    public ADLStoreOptions setDefaultTimeout(int defaultTimeoutInMillis) {
        this.defaultTimeout = defaultTimeoutInMillis;
        return this;
    }

    int getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public ADLStoreOptions alterCipherSuits(boolean alterCipherSuits) {
        this.alterCipherSuits = alterCipherSuits;
        return this;
    }

    boolean shouldAlterCipherSuits() {
        return this.alterCipherSuits;
    }

    public ADLStoreOptions setSSLChannelMode(String sslChannelMode) {
        .SSLSocketFactoryEx.SSLChannelMode[] sslChannelModes;
        for (.SSLSocketFactoryEx.SSLChannelMode mode : sslChannelModes = .SSLSocketFactoryEx.SSLChannelMode.values()) {
            if (!sslChannelMode.equalsIgnoreCase(mode.name())) continue;
            this.sslChannelMode = mode;
            return this;
        }
        this.sslChannelMode = .SSLSocketFactoryEx.SSLChannelMode.Default;
        return this;
    }

    .SSLSocketFactoryEx.SSLChannelMode getSSLChannelMode() {
        return this.sslChannelMode;
    }

    int getMaxRetries() {
        return this.maxRetries;
    }

    public ADLStoreOptions setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    int getExponentialRetryInterval() {
        return this.exponentialRetryInterval;
    }

    public ADLStoreOptions setExponentialRetryInterval(int exponentialRetryInterval) {
        this.exponentialRetryInterval = exponentialRetryInterval;
        return this;
    }

    int getExponentialFactor() {
        return this.exponentialFactor;
    }

    public ADLStoreOptions setExponentialFactor(int exponentialFactor) {
        this.exponentialFactor = exponentialFactor;
        return this;
    }

    public ADLStoreOptions setEnableConditionalCreate(boolean enableConditionalCreate) {
        this.enableConditionalCreate = enableConditionalCreate;
        return this;
    }

    boolean shouldEnableConditionalCreate() {
        return this.enableConditionalCreate;
    }
}

