/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.tracing;

import com.google.errorprone.annotations.MustBeClosed;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.util.Objects;

public final class TracingScopedSpan
implements AutoCloseable {
    private final Span span;
    private final Scope scope;

    private TracingScopedSpan(Span span) {
        this.span = Objects.requireNonNull(span, "span is null");
        this.scope = span.makeCurrent();
    }

    @Override
    public void close() {
        try {
            this.scope.close();
        }
        finally {
            this.span.end();
        }
    }

    @MustBeClosed
    public static TracingScopedSpan scopedSpan(Span span) {
        return new TracingScopedSpan(span);
    }
}

