/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.tracing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import ru.cedrusdata.catalog.tracing.TracingMode;

public class TracingModes {
    public static final TracingModes DISABLED = new TracingModes(false, false, false, false);
    private final boolean traceHttp;
    private final boolean traceApi;
    private final boolean traceFileSystem;
    private final boolean traceStore;

    public static TracingModes merge(Collection<TracingMode> modes) {
        if (modes == null || modes.isEmpty()) {
            return DISABLED;
        }
        modes = new HashSet<TracingMode>(modes);
        boolean traceHttp = false;
        boolean traceApi = false;
        boolean traceFileSystem = false;
        boolean traceStore = false;
        for (TracingMode mode : modes) {
            switch (mode) {
                case ALL: {
                    traceHttp = true;
                    traceApi = true;
                    traceFileSystem = true;
                    traceStore = true;
                    break;
                }
                case HTTP: {
                    traceHttp = true;
                    break;
                }
                case API: {
                    traceApi = true;
                    break;
                }
                case FILE_SYSTEM: {
                    traceFileSystem = true;
                    break;
                }
                case STORE: {
                    traceStore = true;
                }
            }
        }
        return new TracingModes(traceHttp, traceApi, traceFileSystem, traceStore);
    }

    private TracingModes(boolean traceHttp, boolean traceApi, boolean traceFileSystem, boolean traceStore) {
        this.traceHttp = traceHttp;
        this.traceApi = traceApi;
        this.traceFileSystem = traceFileSystem;
        this.traceStore = traceStore;
    }

    public boolean enabled() {
        return this.traceHttp() || this.traceApi() || this.traceFileSystem() || this.traceStore();
    }

    public boolean traceHttp() {
        return this.traceHttp;
    }

    public boolean traceApi() {
        return this.traceApi;
    }

    public boolean traceFileSystem() {
        return this.traceFileSystem;
    }

    public boolean traceStore() {
        return this.traceStore;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TracingModes that = (TracingModes)o;
        if (this.traceHttp != that.traceHttp) {
            return false;
        }
        if (this.traceApi != that.traceApi) {
            return false;
        }
        if (this.traceFileSystem != that.traceFileSystem) {
            return false;
        }
        return this.traceStore == that.traceStore;
    }

    public int hashCode() {
        int result = this.traceHttp ? 1 : 0;
        result = 31 * result + (this.traceApi ? 1 : 0);
        result = 31 * result + (this.traceFileSystem ? 1 : 0);
        result = 31 * result + (this.traceStore ? 1 : 0);
        return result;
    }

    public String toString() {
        ArrayList<TracingMode> res = new ArrayList<TracingMode>();
        if (this.traceHttp) {
            res.add(TracingMode.HTTP);
        }
        if (this.traceApi) {
            res.add(TracingMode.API);
        }
        if (this.traceFileSystem) {
            res.add(TracingMode.FILE_SYSTEM);
        }
        if (this.traceStore) {
            res.add(TracingMode.STORE);
        }
        return ((Object)res).toString();
    }
}

