/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store.jdbc;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import org.intellij.lang.annotations.Language;
import ru.cedrusdata.catalog.store.jdbc.PageSort;
import ru.cedrusdata.catalog.store.jdbc.QueryCondition;

public class ListQueryBuilder<T> {
    public static final String PARAM_LIMIT = "limit";
    @Language(value="SQL")
    private final String baseQuery;
    private final PageSort<T> sort;
    private final boolean offset;
    private final UnaryOperator<String> sqlModifier;

    public static <T> ListQueryBuilder<T> createQueryBuilder(@Language(value="SQL") String baseQuery, PageSort<T> sort) {
        return ListQueryBuilder.createQueryBuilder(baseQuery, null, sort);
    }

    public static <T> ListQueryBuilder<T> createQueryBuilder(@Language(value="SQL") String baseQuery, UnaryOperator<String> sqlModifier, PageSort<T> sort) {
        return new ListQueryBuilder<T>(baseQuery, sqlModifier, sort, false);
    }

    private ListQueryBuilder(@Language(value="SQL") String baseQuery, UnaryOperator<String> sqlModifier, PageSort<T> sort, boolean offset) {
        this.baseQuery = baseQuery.trim();
        this.sqlModifier = sqlModifier;
        this.sort = sort;
        this.offset = offset;
    }

    public PageSort<T> sort() {
        return this.sort;
    }

    public ListQueryBuilder<T> withOffset() {
        return this.offset ? this : new ListQueryBuilder<T>(this.baseQuery, this.sqlModifier, this.sort, true);
    }

    public ListQueryBuilder<T> withoutOffset() {
        return !this.offset ? this : new ListQueryBuilder<T>(this.baseQuery, this.sqlModifier, this.sort, false);
    }

    @Language(value="SQL")
    public String build() {
        return this.build(List.of());
    }

    @Language(value="SQL")
    public String build(List<QueryCondition> conditions) {
        List<String> sqlConditions;
        if (!conditions.isEmpty() || this.offset) {
            sqlConditions = new ArrayList<String>(conditions.size() + (this.offset ? 1 : 0));
            for (QueryCondition condition : conditions) {
                sqlConditions.add(condition.sql());
            }
            if (this.offset) {
                sqlConditions.add(this.sort.conditions());
            }
        } else {
            sqlConditions = List.of();
        }
        return this.buildInternal(sqlConditions);
    }

    private String buildInternal(Collection<String> conditions) {
        StringBuilder res = new StringBuilder(this.baseQuery);
        if (!conditions.isEmpty()) {
            res.append("\nWHERE ");
            boolean first = true;
            for (String condition : conditions) {
                if (first) {
                    first = false;
                } else {
                    res.append(" AND ");
                }
                res.append(condition);
            }
        }
        res.append("\nORDER BY ");
        res.append(Joiner.on((String)", ").join(this.sort.orders()));
        res.append("\nLIMIT :").append(PARAM_LIMIT);
        String sql = res.toString();
        if (this.sqlModifier != null) {
            sql = (String)this.sqlModifier.apply(sql);
        }
        return sql;
    }
}

