/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store.jdbc;

import com.google.inject.Inject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.Predicate;
import org.intellij.lang.annotations.Language;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import ru.cedrusdata.catalog.config.store.CatalogStoreConfig;
import ru.cedrusdata.catalog.core.objectgroup.ObjectGroupDetails;
import ru.cedrusdata.catalog.core.objectgroup.ObjectGroupObjectDetails;
import ru.cedrusdata.catalog.core.objectgroup.ObjectGroupObjectDetailsListResult;
import ru.cedrusdata.catalog.core.objectgroup.ObjectGroupTarget;
import ru.cedrusdata.catalog.iceberg.CedrusDataIcebergObjectType;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableType;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.exception.CatalogObjectGroupAlreadyExistsException;
import ru.cedrusdata.catalog.spi.exception.CatalogObjectGroupInUseException;
import ru.cedrusdata.catalog.spi.exception.CatalogObjectGroupItemAlreadyExistsException;
import ru.cedrusdata.catalog.spi.model.ObjectGroupItemInfo;
import ru.cedrusdata.catalog.spi.model.ObjectGroupItemListResponse;
import ru.cedrusdata.catalog.spi.model.ObjectGroupListResponse;
import ru.cedrusdata.catalog.store.NestedStoreException;
import ru.cedrusdata.catalog.store.ObjectGroupStore;
import ru.cedrusdata.catalog.store.StoreTracingInterceptor;
import ru.cedrusdata.catalog.store.jdbc.JdbcAccessor;
import ru.cedrusdata.catalog.store.jdbc.ListQueryBuilder;
import ru.cedrusdata.catalog.store.jdbc.PageProcessorFactory;
import ru.cedrusdata.catalog.store.jdbc.PageSort;
import ru.cedrusdata.catalog.store.jdbc.QueryCondition;

@StoreTracingInterceptor.Traceable
public class JdbcObjectGroupStore
implements ObjectGroupStore {
    @Language(value="SQL")
    private static final String SQL_OBJECT_GROUP_CREATE = "INSERT INTO metastore_object_group (\n    group_id,\n    group_name,\n    catalog_id,\n    owner_id,\n    description)\nVALUES (\n    :group_id,\n    :group_name,\n    :catalog_id,\n    :owner_id,\n    :description)\nON CONFLICT DO NOTHING\n";
    @Language(value="SQL")
    private static final String SQL_OBJECT_GROUP_UPDATE = "UPDATE metastore_object_group\nSET\n    group_name = :group_name,\n    description = :description\nWHERE group_id = :group_id\n";
    @Language(value="SQL")
    private static final String SQL_OBJECT_GROUP_UPDATE_OWNER = "UPDATE metastore_object_group\nSET owner_id = :owner_id\nWHERE group_id = :group_id\n";
    @Language(value="SQL")
    private static final String SQL_OBJECT_GROUP_DELETE = "DELETE FROM metastore_object_group\nWHERE group_id = :group_id\n";
    @Language(value="SQL")
    private static final String SQL_OBJECT_GROUP_DETAILS_BY_NAME = "SELECT\n    g.group_id group_id,\n    g.group_name group_name,\n    g.owner_id group_owner_id,\n    p.principal_name group_owner_name,\n    g.description group_description,\n    c.catalog_id catalog_id,\n    c.catalog_name catalog_name,\n    c.owner_id catalog_owner_id\nFROM metastore_object_group g\n    INNER JOIN metastore_catalog c ON g.catalog_id = c.catalog_id\n    LEFT OUTER JOIN metastore_principal p ON g.owner_id = p.principal_id\nWHERE\n    g.group_name = :group_name\n";
    @Language(value="SQL")
    private static final String SQL_OBJECT_GROUP_DETAILS_BY_ID = "SELECT\n    g.group_id group_id,\n    g.group_name group_name,\n    g.owner_id group_owner_id,\n    p.principal_name group_owner_name,\n    g.description group_description,\n    c.catalog_id catalog_id,\n    c.catalog_name catalog_name,\n    c.owner_id catalog_owner_id\nFROM metastore_object_group g\n    INNER JOIN metastore_catalog c ON g.catalog_id = c.catalog_id\n    LEFT OUTER JOIN metastore_principal p ON g.owner_id = p.principal_id\nWHERE\n    g.group_id = :group_id\n";
    @Language(value="SQL")
    private static final String SQL_OBJECT_GROUP_LIST = "SELECT\n    g.group_id group_id,\n    g.group_name group_name,\n    g.owner_id group_owner_id,\n    p.principal_name group_owner_name,\n    g.description group_description,\n    c.catalog_id catalog_id,\n    c.catalog_name catalog_name,\n    c.owner_id catalog_owner_id\nFROM metastore_object_group g\n     INNER JOIN metastore_catalog c ON g.catalog_id = c.catalog_id\n     LEFT OUTER JOIN metastore_principal p ON g.owner_id = p.principal_id\n";
    @Language(value="SQL")
    private static final String SQL_OBJECT_GROUP_OBJECT_LIST = "SELECT DISTINCT\n    object_id,\n    object_name,\n    object_owner_id,\n    object_type,\n    object_mv,\n    namespace_id,\n    namespace_name,\n    namespace_owner_id\nFROM (\n    SELECT\n        t.table_id object_id,\n        t.table_name object_name,\n        t.owner_id object_owner_id,\n        t.table_type object_type,\n        t.mv object_mv,\n        n.namespace_id namespace_id,\n        n.namespace_name namespace_name,\n        n.owner_id namespace_owner_id\n    FROM metastore_object_group_item gi\n        INNER JOIN metastore_iceberg_table t ON gi.object_id = t.table_id\n        INNER JOIN metastore_iceberg_namespace n ON t.namespace_id = n.namespace_id\n    WHERE gi.object_id IS NOT NULL AND {condition}\n    UNION ALL\n    SELECT\n        t.table_id object_id,\n        t.table_name object_name,\n        t.owner_id object_owner_id,\n        t.table_type object_type,\n        t.mv object_mv,\n        n.namespace_id namespace_id,\n        n.namespace_name namespace_name,\n        n.owner_id namespace_owner_id\n    FROM metastore_object_group_item gi\n        INNER JOIN metastore_iceberg_namespace n ON gi.namespace_id = n.namespace_id\n        INNER JOIN metastore_iceberg_table t ON n.namespace_id = t.namespace_id\n    WHERE gi.namespace_id IS NOT NULL AND {condition}\n    UNION ALL\n    SELECT\n        t.table_id object_id,\n        t.table_name object_name,\n        t.owner_id object_owner_id,\n        t.table_type object_type,\n        t.mv object_mv,\n        n.namespace_id namespace_id,\n        n.namespace_name namespace_name,\n        n.owner_id namespace_owner_id\n    FROM metastore_object_group_item gi\n        INNER JOIN metastore_object_group g ON gi.group_id = g.group_id\n        INNER JOIN metastore_iceberg_namespace n ON g.catalog_id = n.catalog_id\n        INNER JOIN metastore_iceberg_table t ON n.namespace_id = t.namespace_id\n    WHERE gi.namespace_id IS NULL AND gi.object_id IS NULL AND {condition}\n) subquery\n";
    @Language(value="SQL")
    private static final String SQL_OBJECT_GROUP_ITEM_CREATE = "INSERT INTO metastore_object_group_item (\n    group_item_id,\n    group_id,\n    namespace_id,\n    object_id)\nVALUES (\n    :group_item_id,\n    :group_id,\n    :namespace_id,\n    :object_id)\n";
    @Language(value="SQL")
    private static final String SQL_OBJECT_GROUP_ITEM_DELETE = "DELETE FROM metastore_object_group_item\nWHERE group_item_id = :group_item_id\n";
    @Language(value="SQL")
    private static final String SQL_OBJECT_GROUP_ITEM_LIST = "SELECT\n    gi.group_item_id group_item_id,\n    COALESCE(n1.namespace_name, n2.namespace_name) namespace_name,\n    t2.table_name object_name\nFROM metastore_object_group_item gi\n     LEFT OUTER JOIN metastore_iceberg_namespace n1 ON gi.namespace_id = n1.namespace_id\n     LEFT OUTER JOIN metastore_iceberg_table t2 ON gi.object_id = t2.table_id\n     LEFT OUTER JOIN metastore_iceberg_namespace n2 ON t2.namespace_id = n2.namespace_id\n";
    private final JdbcAccessor accessor;
    private final int maxPageSize;
    private final PageProcessorFactory<ObjectGroupDetails> listPageProcessorFactory;
    private final PageProcessorFactory<ObjectGroupItemInfo> listItemsPageProcessorFactory;

    @Inject
    public JdbcObjectGroupStore(JdbcAccessor accessor, CatalogStoreConfig config) {
        this.accessor = accessor;
        this.maxPageSize = config.getStoreMaxPageSize();
        this.listPageProcessorFactory = new PageProcessorFactory(ListQueryBuilder.createQueryBuilder(SQL_OBJECT_GROUP_LIST, PageSort.sort(PageSort.uuidSort("g.group_id", ObjectGroupDetails::objectGroupId))), this.maxPageSize);
        this.listItemsPageProcessorFactory = new PageProcessorFactory(ListQueryBuilder.createQueryBuilder(SQL_OBJECT_GROUP_ITEM_LIST, PageSort.sort(PageSort.uuidSort("gi.group_item_id", ObjectGroupItemInfo::getItemId))), this.maxPageSize);
    }

    @Override
    public boolean createIfNotExists(String objectGroupName, UUID catalogId, UUID ownerId, String description, Optional<ObjectGroupTarget> target) {
        UUID groupId = UUID.randomUUID();
        return this.accessor.execute(handle -> (Boolean)handle.inTransaction(txHandle -> {
            int updateCount = ((Update)((Update)((Update)((Update)((Update)txHandle.createUpdate(SQL_OBJECT_GROUP_CREATE).bind("group_id", groupId)).bind("group_name", objectGroupName)).bind("catalog_id", catalogId)).bind("owner_id", ownerId)).bind("description", description)).execute();
            if (updateCount == 0) {
                return false;
            }
            if (target.isPresent()) {
                this.createItem(txHandle, groupId, (ObjectGroupTarget)target.get());
            }
            return true;
        }));
    }

    @Override
    public boolean updateIfExists(UUID objectGroupId, String objectGroupName, String description) {
        return this.accessor.execute(handle -> {
            try {
                return ((Update)((Update)((Update)handle.createUpdate(SQL_OBJECT_GROUP_UPDATE).bind("group_id", objectGroupId)).bind("group_name", objectGroupName)).bind("description", description)).execute() == 1;
            }
            catch (Exception e) {
                if (this.accessor.isConstraintViolationException(e)) {
                    throw new NestedStoreException((RuntimeException)new CatalogObjectGroupAlreadyExistsException(objectGroupName));
                }
                throw e;
            }
        });
    }

    @Override
    public boolean updateOwnerIfExists(UUID objectGroupId, UUID ownerId) {
        return this.accessor.execute(handle -> ((Update)((Update)handle.createUpdate(SQL_OBJECT_GROUP_UPDATE_OWNER).bind("group_id", objectGroupId)).bind("owner_id", ownerId)).execute() == 1);
    }

    @Override
    public boolean deleteIfExists(UUID objectGroupId, String objectGroupName) {
        return this.accessor.execute(handle -> {
            try {
                return ((Update)handle.createUpdate(SQL_OBJECT_GROUP_DELETE).bind("group_id", objectGroupId)).execute() == 1;
            }
            catch (Exception e) {
                if (this.accessor.isConstraintViolationException(e)) {
                    throw new NestedStoreException((RuntimeException)new CatalogObjectGroupInUseException(objectGroupName));
                }
                throw e;
            }
        });
    }

    @Override
    public Optional<ObjectGroupDetails> details(String objectGroupName) {
        return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_OBJECT_GROUP_DETAILS_BY_NAME).bind("group_name", objectGroupName)).map((rs, ctx) -> this.toDetails(rs)).findOne());
    }

    @Override
    public Optional<ObjectGroupDetails> details(UUID objectGroupId) {
        return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_OBJECT_GROUP_DETAILS_BY_ID).bind("group_id", objectGroupId)).map((rs, ctx) -> this.toDetails(rs)).findOne());
    }

    @Override
    public ObjectGroupListResponse list(ResultPage page, Predicate<ObjectGroupDetails> predicate) {
        return this.listPageProcessorFactory.list(this.accessor, page, this::toDetails, predicate, (items, nextPageToken) -> new ObjectGroupListResponse(items.stream().map(ObjectGroupDetails::toInfo).toList(), nextPageToken));
    }

    private ObjectGroupDetails toDetails(ResultSet rs) throws SQLException {
        return new ObjectGroupDetails(this.accessor.getUuid(rs, "group_id"), rs.getString("group_name"), this.accessor.getUuid(rs, "catalog_id"), rs.getString("catalog_name"), this.accessor.getOptionalUuid(rs, "catalog_owner_id"), this.accessor.getOptionalUuid(rs, "group_owner_id"), Optional.of(rs.getString("group_owner_name")), rs.getString("group_description"));
    }

    @Override
    public ObjectGroupObjectDetailsListResult listObjects(UUID objectGroupId, Optional<CedrusDataIcebergObjectType> objectType, Optional<UUID> itemId, ResultPage page, Predicate<ObjectGroupObjectDetails> predicate) {
        String sql = JdbcObjectGroupStore.prepareListObjectsSql(objectGroupId, objectType, itemId);
        PageProcessorFactory<ObjectGroupObjectDetails> listObjectsPageProcessorFactory = new PageProcessorFactory<ObjectGroupObjectDetails>(ListQueryBuilder.createQueryBuilder(sql, PageSort.sort(PageSort.uuidSort("object_id", ObjectGroupObjectDetails::objectId))), this.maxPageSize);
        return listObjectsPageProcessorFactory.list(this.accessor, page, this::toObjectDetails, predicate, ObjectGroupObjectDetailsListResult::new);
    }

    private static String prepareListObjectsSql(UUID objectGroupId, Optional<CedrusDataIcebergObjectType> objectType, Optional<UUID> itemId) {
        StringJoiner joiner = new StringJoiner(" AND ");
        joiner.add("gi.group_id = '" + String.valueOf(objectGroupId) + "'");
        if (objectType.isPresent()) {
            switch (objectType.get()) {
                case TABLE: {
                    joiner.add("t.table_type = " + IcebergTableType.TABLE.identifier());
                    joiner.add("t.mv = 0");
                    break;
                }
                case VIEW: {
                    joiner.add("t.table_type = " + IcebergTableType.VIEW.identifier());
                    break;
                }
                case CEDRUSDATA_MATERIALIZED_VIEW: {
                    joiner.add("t.table_type = " + IcebergTableType.TABLE.identifier());
                    joiner.add("t.mv = 1");
                }
            }
        }
        if (itemId.isPresent()) {
            joiner.add("gi.group_item_id = '" + String.valueOf(itemId.get()) + "'");
        }
        String condition = joiner.toString();
        return SQL_OBJECT_GROUP_OBJECT_LIST.replace("{condition}", condition);
    }

    private ObjectGroupObjectDetails toObjectDetails(ResultSet rs) throws SQLException {
        boolean mv;
        IcebergTableType type = IcebergTableType.resolve(rs.getInt("object_type"));
        boolean bl = mv = rs.getShort("object_mv") != 0;
        CedrusDataIcebergObjectType objectType = type == IcebergTableType.TABLE ? (mv ? CedrusDataIcebergObjectType.CEDRUSDATA_MATERIALIZED_VIEW : CedrusDataIcebergObjectType.TABLE) : CedrusDataIcebergObjectType.VIEW;
        return new ObjectGroupObjectDetails(this.accessor.getUuid(rs, "namespace_id"), rs.getString("namespace_name"), this.accessor.getOptionalUuid(rs, "namespace_owner_id"), this.accessor.getUuid(rs, "object_id"), rs.getString("object_name"), this.accessor.getOptionalUuid(rs, "object_owner_id"), objectType);
    }

    @Override
    public void addItem(UUID objectGroupId, ObjectGroupTarget target) {
        this.accessor.execute(handle -> {
            try {
                this.createItem((Handle)handle, objectGroupId, target);
            }
            catch (Exception e) {
                if (this.accessor.isConstraintViolationException(e)) {
                    throw new NestedStoreException((RuntimeException)new CatalogObjectGroupItemAlreadyExistsException());
                }
                throw e;
            }
        });
    }

    @Override
    public boolean deleteItemIfExists(UUID itemId) {
        return this.accessor.execute(handle -> ((Update)handle.createUpdate(SQL_OBJECT_GROUP_ITEM_DELETE).bind("group_item_id", itemId)).execute() == 1);
    }

    @Override
    public ObjectGroupItemListResponse listItems(UUID objectGroupId, ResultPage page) {
        QueryCondition condition = QueryCondition.eq("gi.group_id", objectGroupId);
        return this.listItemsPageProcessorFactory.list(this.accessor, page, (pageProcessor, handle) -> pageProcessor.createQuery((Handle)handle, condition), this::toItemInfo, item -> true, ObjectGroupItemListResponse::new);
    }

    private ObjectGroupItemInfo toItemInfo(ResultSet rs) throws SQLException {
        String objectName;
        String namespaceName = rs.getString("namespace_name");
        if (namespaceName == null) {
            namespaceName = "*";
        }
        if ((objectName = rs.getString("object_name")) == null) {
            objectName = "*";
        }
        return new ObjectGroupItemInfo(this.accessor.getUuid(rs, "group_item_id"), namespaceName, objectName);
    }

    private void createItem(Handle handle, UUID objectGroupId, ObjectGroupTarget target) {
        UUID groupItemId = target.objectId().isEmpty() && target.namespaceId().isEmpty() ? objectGroupId : UUID.randomUUID();
        ((Update)((Update)((Update)((Update)handle.createUpdate(SQL_OBJECT_GROUP_ITEM_CREATE).bind("group_item_id", groupItemId)).bind("group_id", objectGroupId)).bindByType("namespace_id", target.namespaceId().orElse(null), UUID.class)).bindByType("object_id", target.objectId().orElse(null), UUID.class)).execute();
    }
}

