/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import org.jdbi.v3.core.ConnectionFactory;
import org.postgresql.Driver;
import org.sqlite.JDBC;
import ru.cedrusdata.catalog.store.jdbc.JdbcConnectionDetails;
import ru.cedrusdata.catalog.store.jdbc.JdbcDatabaseType;

public class JdbcDirectConnectionFactory
implements ConnectionFactory {
    private final JdbcConnectionDetails connectionDetails;

    JdbcDirectConnectionFactory(JdbcConnectionDetails connectionDetails) {
        this.connectionDetails = connectionDetails;
    }

    public Connection openConnection() throws SQLException {
        return switch (this.connectionDetails.databaseType()) {
            default -> throw new MatchException(null, null);
            case JdbcDatabaseType.SQLITE -> new JDBC().connect(this.connectionDetails.url(), this.connectionDetails.properties());
            case JdbcDatabaseType.POSTGRESQL -> new Driver().connect(this.connectionDetails.url(), this.connectionDetails.properties());
        };
    }
}

