/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.server.jaxrs;

import com.google.inject.Inject;
import io.airlift.jaxrs.tracing.TracingFilter;
import io.opentelemetry.api.OpenTelemetry;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;
import java.util.Objects;
import ru.cedrusdata.catalog.spi.exception.CatalogInternalServerErrorException;
import ru.cedrusdata.catalog.tracing.TracingProvider;

public class CatalogTracingDynamicFeature
implements DynamicFeature {
    private final TracingProvider tracingProvider;

    @Inject
    public CatalogTracingDynamicFeature(TracingProvider tracingProvider) {
        this.tracingProvider = Objects.requireNonNull(tracingProvider, "tracingProvider");
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        context.register((Object)new TracingFilter(this.tracingProvider.telemetryForHttp().orElse(OpenTelemetry.noop()), this.tracingProvider.tracerForHttp().orElseThrow(() -> new CatalogInternalServerErrorException("HTTP tracer is not available")), resourceInfo.getResourceClass().getName(), resourceInfo.getResourceMethod().getName()));
    }
}

