/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.plugin;

import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.opentelemetry.api.OpenTelemetry;
import ru.cedrusdata.catalog.plugin.CatalogPluginContextProvider;
import ru.cedrusdata.catalog.plugin.CatalogPluginManager;
import ru.cedrusdata.catalog.plugin.CatalogPluginProvider;
import ru.cedrusdata.catalog.plugin.CatalogPluginRegistry;
import ru.cedrusdata.catalog.plugin.DefaultCatalogPluginProvider;
import ru.cedrusdata.catalog.spi.CatalogResourceResolver;
import ru.cedrusdata.catalog.spi.jmx.CatalogJmxNameCheck;
import ru.cedrusdata.catalog.tracing.TracingProvider;

public class CatalogPluginModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        OptionalBinder.newOptionalBinder((Binder)binder, CatalogPluginProvider.class).setDefault().to(DefaultCatalogPluginProvider.class).in(Scopes.SINGLETON);
        binder.bind(CatalogPluginRegistry.class).to(CatalogPluginManager.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    public CatalogPluginContextProvider getCatalogPluginContextProvider(CatalogResourceResolver resourceResolver, CatalogJmxNameCheck jmxNameCheck, TracingProvider tracingProvider) {
        OpenTelemetry fileSystemOpenTelemetry = tracingProvider.telemetryForFileSystem().orElse(OpenTelemetry.noop());
        return new CatalogPluginContextProvider(resourceResolver, jmxNameCheck, fileSystemOpenTelemetry);
    }
}

