/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.jmx;

import com.google.inject.Inject;
import io.airlift.jmx.JmxAgent;
import io.airlift.jmx.JmxConfig;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import ru.cedrusdata.catalog.config.CatalogConfig;

public class CatalogJmxAgent {
    private final CatalogConfig config;
    private final AtomicBoolean initialized = new AtomicBoolean();

    @Inject
    public CatalogJmxAgent(CatalogConfig config) {
        this.config = config;
    }

    @PostConstruct
    public void initialize() throws IOException {
        if (!this.initialized.compareAndSet(false, true)) {
            return;
        }
        if (this.config.getJmxRemotePort() == null) {
            return;
        }
        JmxConfig jmxConfig = new JmxConfig().setRmiRegistryPort(this.config.getJmxRemotePort()).setRmiServerPort(this.config.getJmxRemoteRmiPort());
        new JmxAgent(jmxConfig);
    }
}

