/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg.table;

import java.util.Optional;
import java.util.UUID;
import ru.cedrusdata.catalog.core.security.authorization.securable.ObjectInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurableItem;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurableType;
import ru.cedrusdata.catalog.iceberg.CedrusDataIcebergObjectType;
import ru.cedrusdata.catalog.spi.exception.CatalogInternalServerErrorException;
import ru.cedrusdata.catalog.spi.model.IcebergObjectInfo;

public record IcebergObjectInfoEx(IcebergObjectInfo info, UUID catalogId, Optional<UUID> catalogOwnerId, UUID namespaceId, Optional<UUID> namespaceOwnerId, UUID objectId, Optional<UUID> objectOwnerId) {
    public ObjectInternalSecurable toSecurable() {
        CedrusDataIcebergObjectType objectType = (CedrusDataIcebergObjectType)CedrusDataIcebergObjectType.parse((String)this.info.getObjectType()).orElseThrow(() -> new CatalogInternalServerErrorException("Unknown object type: " + this.info.getObjectType()));
        SecurableType securableType = switch (objectType) {
            default -> throw new MatchException(null, null);
            case CedrusDataIcebergObjectType.TABLE -> SecurableType.SECURABLE_TYPE_TABLE;
            case CedrusDataIcebergObjectType.VIEW -> SecurableType.SECURABLE_TYPE_VIEW;
            case CedrusDataIcebergObjectType.CEDRUSDATA_MATERIALIZED_VIEW -> SecurableType.SECURABLE_TYPE_MATERIALIZED_VIEW;
        };
        return new ObjectInternalSecurable(securableType, new SecurableItem(this.catalogId, this.catalogOwnerId, this.info.getCatalogName()), new SecurableItem(this.namespaceId, this.namespaceOwnerId, this.info.getNamespaceName()), new SecurableItem(this.objectId, this.objectOwnerId, this.info.getObjectName()));
    }
}

