/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg.table;

import com.google.common.base.Verify;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import ru.cedrusdata.catalog.CatalogObjectNameValidation;
import ru.cedrusdata.catalog.CurrentTimeSupplier;
import ru.cedrusdata.catalog.core.security.authorization.Authorizer;
import ru.cedrusdata.catalog.core.security.authorization.AuthorizerObjectType;
import ru.cedrusdata.catalog.core.security.authorization.PrivilegeInternalService;
import ru.cedrusdata.catalog.iceberg.CedrusDataIcebergObjectType;
import ru.cedrusdata.catalog.iceberg.io.CatalogIcebergFileIOFactory;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceContext;
import ru.cedrusdata.catalog.iceberg.rest.IcebergOptions;
import ru.cedrusdata.catalog.iceberg.table.IcebergCatalog;
import ru.cedrusdata.catalog.iceberg.table.IcebergCteDetails;
import ru.cedrusdata.catalog.iceberg.table.IcebergCteTableForReuseResponseEx;
import ru.cedrusdata.catalog.iceberg.table.IcebergExpiredCteTable;
import ru.cedrusdata.catalog.iceberg.table.IcebergMaterializedViewDetails;
import ru.cedrusdata.catalog.iceberg.table.IcebergMaterializedViewForRewriteInfoEx;
import ru.cedrusdata.catalog.iceberg.table.IcebergObjectDetails;
import ru.cedrusdata.catalog.iceberg.table.IcebergObjectExtendedDetails;
import ru.cedrusdata.catalog.iceberg.table.IcebergObjectInfoEx;
import ru.cedrusdata.catalog.iceberg.table.IcebergObjectRestListResult;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableMetadataCache;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableType;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.exception.CatalogBadRequestException;
import ru.cedrusdata.catalog.spi.exception.CatalogInternalServerErrorException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergObjectAlreadyExistsException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergObjectCommitFailedException;
import ru.cedrusdata.catalog.spi.model.IcebergMaterializedViewForRewriteListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergObjectListResponse;
import ru.cedrusdata.catalog.store.IcebergObjectStore;

public class IcebergInternalTableService {
    private final IcebergObjectStore store;
    private final IcebergTableMetadataCache tableMetadataCache;
    private final CurrentTimeSupplier currentTimeSupplier;
    private final PrivilegeInternalService privilegeInternalService;

    @Inject
    public IcebergInternalTableService(IcebergTableMetadataCache tableMetadataCache, IcebergObjectStore store, CurrentTimeSupplier currentTimeSupplier, PrivilegeInternalService privilegeInternalService) {
        this.tableMetadataCache = Objects.requireNonNull(tableMetadataCache, "tableMetadataCache");
        this.store = Objects.requireNonNull(store, "store");
        this.currentTimeSupplier = Objects.requireNonNull(currentTimeSupplier, "currentTimeSupplier");
        this.privilegeInternalService = Objects.requireNonNull(privilegeInternalService, "privilegeInternalService");
    }

    public Optional<IcebergObjectInfoEx> infoByName(UUID catalogId, UUID namespaceId, String objectName) {
        return this.store.infoByName(catalogId, namespaceId, objectName);
    }

    public IcebergObjectListResponse list(Optional<String> catalogName, Optional<String> namespaceName, Optional<String> objectType, ResultPage page, Predicate<IcebergObjectInfoEx> predicate) {
        Optional<CedrusDataIcebergObjectType> parsedObjectType = objectType.map(caption -> (CedrusDataIcebergObjectType)CedrusDataIcebergObjectType.parse((String)caption).orElseThrow(() -> new CatalogBadRequestException("Invalid object ype value: " + caption)));
        return this.store.list(catalogName, namespaceName, parsedObjectType, page, predicate);
    }

    public IcebergMaterializedViewForRewriteListResponse listMaterializedViewsForRewrite(UUID catalogId, Set<String> tableNames, Predicate<IcebergMaterializedViewForRewriteInfoEx> predicate) {
        return this.store.listMaterializedViewsForRewrite(catalogId, tableNames, predicate);
    }

    public Optional<IcebergCteTableForReuseResponseEx> cteTableForReuse(UUID catalogId, String canonicalPlan, long minRemainingTtl) {
        long minExpiresAt = this.currentTimeSupplier.currentTimeMillis() + minRemainingTtl;
        return this.store.cteTableForReuse(catalogId, canonicalPlan, minExpiresAt);
    }

    public List<IcebergExpiredCteTable> expiredCteTables(UUID catalogId, long currentTime) {
        return this.store.expiredCteTables(catalogId, currentTime);
    }

    public IcebergCatalog asCatalog(Authorizer authorizer, IcebergNamespaceContext namespaceContext, Optional<IcebergObjectExtendedDetails> objectDetails, CatalogIcebergFileIOFactory ioFactory, IcebergOptions icebergOptions) {
        return new IcebergCatalog(this, authorizer, this.currentTimeSupplier, this.tableMetadataCache, namespaceContext, objectDetails, ioFactory, icebergOptions);
    }

    public void createOrUpdate(IcebergNamespaceContext namespaceContext, Optional<UUID> objectId, String objectName, AuthorizerObjectType objectType, String metadataLocation, Optional<String> oldMetadataLocation, Optional<IcebergMaterializedViewDetails> materializedViewDetails, Optional<IcebergCteDetails> cteDetails) {
        if (oldMetadataLocation.isEmpty()) {
            Verify.verify((boolean)objectId.isEmpty());
            this.create(namespaceContext, objectName, objectType, namespaceContext.catalogContext().currentPrincipal().id(), metadataLocation, materializedViewDetails, cteDetails);
        } else {
            Verify.verify((boolean)objectId.isPresent());
            this.update(namespaceContext, objectId.get(), objectName, objectType, metadataLocation, oldMetadataLocation.get(), materializedViewDetails, cteDetails);
        }
    }

    private void create(IcebergNamespaceContext namespaceContext, String name, AuthorizerObjectType objectType, UUID ownerId, String metadataLocation, Optional<IcebergMaterializedViewDetails> materializedViewDetails, Optional<IcebergCteDetails> cteDetails) {
        boolean created = this.store.createIfNotExist(namespaceContext.namespaceId(), name, objectType.physicalType(), ownerId, metadataLocation, materializedViewDetails, cteDetails);
        if (!created) {
            throw new IcebergObjectAlreadyExistsException(namespaceContext.namespaceName(), name);
        }
    }

    private void update(IcebergNamespaceContext namespaceContext, UUID objectId, String objectName, AuthorizerObjectType objectType, String metadataLocation, String oldMetadataLocation, Optional<IcebergMaterializedViewDetails> materializedViewDetails, Optional<IcebergCteDetails> cteDetails) {
        boolean updated = this.store.updateIfExists(namespaceContext.namespaceId(), objectId, objectName, objectType.physicalType(), metadataLocation, oldMetadataLocation, materializedViewDetails, cteDetails);
        if (!updated) {
            throw new IcebergObjectCommitFailedException(namespaceContext.namespaceName(), objectName);
        }
        this.invalidateCache(namespaceContext, objectName, objectType.physicalType());
    }

    public boolean rename(String catalogName, IcebergNamespaceContext sourceNamespaceContext, String sourceName, UUID sourceId, IcebergNamespaceContext destinationNamespaceContext, String destinationName, IcebergTableType type) {
        boolean renamed = this.store.renameIfExists(catalogName, sourceNamespaceContext.namespaceId(), sourceName, sourceId, destinationNamespaceContext.namespaceName(), destinationNamespaceContext.namespaceId(), destinationName, type);
        if (renamed) {
            this.invalidateCache(sourceNamespaceContext, sourceName, type);
        }
        return renamed;
    }

    public boolean delete(IcebergNamespaceContext namespaceContext, UUID objectId, String objectName, IcebergTableType type) {
        String normalizedName = CatalogObjectNameValidation.VALIDATION_OBJECT.normalizeObjectName(objectName);
        boolean deleted = this.store.deleteIfExists(objectId);
        if (deleted) {
            this.invalidateCache(namespaceContext, normalizedName, type);
            this.privilegeInternalService.clearPrivileges();
        }
        return deleted;
    }

    public ListTablesResponse listForRest(IcebergNamespaceContext namespaceContext, IcebergTableType type, ResultPage page, Predicate<IcebergObjectRestListResult.Entry> predicate) {
        IcebergObjectRestListResult result = this.store.restList(namespaceContext.namespaceId(), type, page, predicate);
        ListTablesResponse.Builder builder = ListTablesResponse.builder();
        for (IcebergObjectRestListResult.Entry object : result.objects()) {
            builder.add(namespaceContext.icebergTable(object.objectName()));
        }
        builder.nextPageToken(result.token());
        return builder.build();
    }

    public boolean updateOwnerIfExists(IcebergNamespaceContext namespaceContext, String name, UUID id, UUID newOwnerId, IcebergTableType physicalObjectType) {
        boolean updated = this.store.updateOwnerIfExists(id, newOwnerId);
        if (updated && this.tableMetadataCache.enabled()) {
            this.tableMetadataCache.invalidate(IcebergInternalTableService.createDetailsCacheKey(namespaceContext, name, physicalObjectType));
        }
        return updated;
    }

    public Optional<IcebergObjectDetails> details(IcebergNamespaceContext namespaceContext, String name) {
        for (IcebergTableType type : IcebergTableType.values()) {
            Optional<IcebergObjectDetails> res = this.details(namespaceContext, name, type);
            if (!res.isPresent()) continue;
            return res;
        }
        return Optional.empty();
    }

    public Optional<IcebergObjectDetails> details(IcebergNamespaceContext namespaceContext, String name, IcebergTableType type) {
        if (this.tableMetadataCache.enabled()) {
            String cacheKey = IcebergInternalTableService.createDetailsCacheKey(namespaceContext, name, type);
            try {
                return this.tableMetadataCache.withKeyLock(cacheKey, () -> {
                    Optional<IcebergObjectDetails> res = Optional.ofNullable(this.tableMetadataCache.getDetails(cacheKey));
                    if (res.isEmpty() && (res = this.store.details(namespaceContext.namespaceId(), name, type)).isPresent()) {
                        this.tableMetadataCache.putDetails(cacheKey, res.get());
                    }
                    return res;
                });
            }
            catch (IOException e) {
                throw new CatalogInternalServerErrorException("Unexpected exception: " + e.getMessage(), (Throwable)e);
            }
        }
        return this.store.details(namespaceContext.namespaceId(), name, type);
    }

    private void invalidateCache(IcebergNamespaceContext namespaceContext, String name, IcebergTableType type) {
        if (this.tableMetadataCache.enabled()) {
            String cacheKey = IcebergInternalTableService.createDetailsCacheKey(namespaceContext, name, type);
            this.tableMetadataCache.invalidate(cacheKey);
        }
    }

    private static String createDetailsCacheKey(IcebergNamespaceContext namespaceContext, String name, IcebergTableType type) {
        return IcebergTableMetadataCache.createDetailsKey(namespaceContext.catalogContext().catalogId(), namespaceContext.namespaceId(), name, type);
    }
}

