/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg.rest;

import com.google.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import org.apache.iceberg.catalog.Namespace;
import ru.cedrusdata.catalog.CatalogObjectNameValidation;
import ru.cedrusdata.catalog.api.EmbeddedInternalCatalogClientFactory;
import ru.cedrusdata.catalog.iceberg.LoadObjectResponse;
import ru.cedrusdata.catalog.iceberg.rest.AbstractIcebergResource;
import ru.cedrusdata.catalog.iceberg.rest.IcebergOptions;
import ru.cedrusdata.catalog.server.security.ResourceSecurity;
import ru.cedrusdata.catalog.server.security.ResourceType;

@ResourceType(value=ResourceType.Type.ICEBERG)
@ResourceSecurity(value=ResourceSecurity.Type.AUTHENTICATED)
@Path(value="/catalog/iceberg/v1")
public class IcebergCedrusDataResource
extends AbstractIcebergResource {
    @Inject
    public IcebergCedrusDataResource(EmbeddedInternalCatalogClientFactory clientFactory) {
        super(clientFactory);
    }

    @GET
    @Path(value="/{prefix}/namespaces/{namespace}/objects/{object}")
    @Produces(value={"application/json"})
    public Response loadObject(@HeaderParam(value="X-Iceberg-Access-Delegation") String icebergAccessDelegation, @PathParam(value="prefix") String catalogName, @PathParam(value="namespace") String namespaceName, @PathParam(value="object") String objectName, @QueryParam(value="snapshots") String snapshots, @Context SecurityContext securityContext, @Context HttpHeaders headers) {
        catalogName = CatalogObjectNameValidation.VALIDATION_CATALOG.decodeString(catalogName);
        Namespace namespace = CatalogObjectNameValidation.decodeIcebergNamespace(namespaceName);
        objectName = CatalogObjectNameValidation.VALIDATION_OBJECT.decodeString(objectName);
        LoadObjectResponse response = this.createClient(securityContext).restIcebergLoadObject(catalogName, namespace, objectName, snapshots, icebergAccessDelegation, IcebergOptions.createIcebergOptions(headers));
        return Response.ok((Object)response).build();
    }
}

