/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg.namespace;

import java.util.Optional;
import java.util.UUID;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import ru.cedrusdata.catalog.CatalogObjectNameValidation;
import ru.cedrusdata.catalog.core.security.authorization.securable.NamespaceInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurableItem;
import ru.cedrusdata.catalog.iceberg.catalog.IcebergCatalogContext;

public record IcebergNamespaceContext(IcebergCatalogContext catalogContext, UUID namespaceId, String namespaceName, Optional<UUID> ownerId) {
    public IcebergNamespaceContext(IcebergCatalogContext catalogContext, UUID namespaceId, String namespaceName, Optional<UUID> ownerId) {
        this.catalogContext = catalogContext;
        this.namespaceId = namespaceId;
        this.namespaceName = CatalogObjectNameValidation.VALIDATION_NAMESPACE.normalizeObjectName(namespaceName);
        this.ownerId = ownerId;
    }

    public Namespace icebergNamespace() {
        return Namespace.of((String[])new String[]{this.namespaceName});
    }

    public TableIdentifier icebergTable(String tableName) {
        String normalizedTableName = CatalogObjectNameValidation.VALIDATION_OBJECT.normalizeObjectName(tableName);
        return TableIdentifier.of((String[])new String[]{this.namespaceName, normalizedTableName});
    }

    public NamespaceInternalSecurable toSecurable() {
        return new NamespaceInternalSecurable(new SecurableItem(this.catalogContext.catalogId(), this.catalogContext.ownerId(), this.catalogContext.catalogName()), new SecurableItem(this.namespaceId, this.ownerId, this.namespaceName));
    }
}

