/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg.io;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iceberg.io.BulkDeletionFailureException;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.SupportsBulkOperations;
import ru.cedrusdata.catalog.iceberg.io.CatalogIcebergInputFile;
import ru.cedrusdata.catalog.iceberg.io.CatalogIcebergOutputFile;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystem;

public class CatalogIcebergFileIO
implements SupportsBulkOperations {
    private static final int DELETE_BATCH_SIZE = 1000;
    private static final int BATCH_DELETE_PATHS_MESSAGE_LIMIT = 5;
    private final CatalogFileSystem fileSystem;

    public CatalogIcebergFileIO(CatalogFileSystem fileSystem) {
        this.fileSystem = Objects.requireNonNull(fileSystem, "fileSystem is null");
    }

    public CatalogFileSystem fileSystem() {
        return this.fileSystem;
    }

    public InputFile newInputFile(String path) {
        return new CatalogIcebergInputFile(this.fileSystem.newInputFile(path));
    }

    public InputFile newInputFile(String path, long length) {
        return new CatalogIcebergInputFile(this.fileSystem.newInputFile(path, length));
    }

    public OutputFile newOutputFile(String path) {
        return new CatalogIcebergOutputFile(this.fileSystem, path);
    }

    public void deleteFile(String path) {
        try {
            this.fileSystem.deleteFile(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to delete file: " + path, e);
        }
    }

    public void deleteFile(InputFile file) {
        super.deleteFile(file);
    }

    public void deleteFile(OutputFile file) {
        super.deleteFile(file);
    }

    public void deleteFiles(Iterable<String> pathsToDelete) throws BulkDeletionFailureException {
        Iterable partitions = Iterables.partition(pathsToDelete, (int)1000);
        partitions.forEach(this::deleteBatch);
    }

    private void deleteBatch(List<String> filesToDelete) {
        try {
            this.fileSystem.deleteFiles(filesToDelete);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to delete some or all of files: " + Stream.concat(filesToDelete.stream().limit(5L), filesToDelete.size() > 5 ? Stream.of("...") : Stream.of(new String[0])).collect(Collectors.joining(", ", "[", "]")), e);
        }
    }

    public void deleteDirectory(String path) {
        try {
            this.fileSystem.deleteDirectory(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to delete directory: " + path, e);
        }
    }

    public Map<String, String> properties() {
        return Map.of();
    }

    public void initialize(Map<String, String> properties) {
        throw new UnsupportedOperationException("CatalogFileIO does not support initialization by properties");
    }

    public void close() {
        this.fileSystem.close();
    }
}

