/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.security.authorization.securable;

import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import ru.cedrusdata.catalog.core.security.authorization.CatalogPrivilege;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurableType;

public class SecurableTypeUsagePrivileges {
    private static final Map<SecurableType, Optional<CatalogPrivilege>> SECURABLE_TYPE_TO_PRIVILEGE;
    private static final Map<SecurableType, Set<CatalogPrivilege>> SECURABLE_TYPE_TO_EFFECTIVE_PRIVILEGES;

    private static Optional<CatalogPrivilege> resolveUsagePrivilege(SecurableType securableType) {
        return switch (securableType) {
            default -> throw new MatchException(null, null);
            case SecurableType.SECURABLE_TYPE_METASTORE -> Optional.empty();
            case SecurableType.SECURABLE_TYPE_PRINCIPAL -> Optional.of(CatalogPrivilege.PRIVILEGE_PRINCIPAL_USAGE);
            case SecurableType.SECURABLE_TYPE_FILE_SYSTEM -> Optional.of(CatalogPrivilege.PRIVILEGE_FILE_SYSTEM_USAGE);
            case SecurableType.SECURABLE_TYPE_CATALOG -> Optional.of(CatalogPrivilege.PRIVILEGE_CATALOG_USAGE);
            case SecurableType.SECURABLE_TYPE_NAMESPACE -> Optional.of(CatalogPrivilege.PRIVILEGE_NAMESPACE_USAGE);
            case SecurableType.SECURABLE_TYPE_TABLE -> Optional.of(CatalogPrivilege.PRIVILEGE_TABLE_USAGE);
            case SecurableType.SECURABLE_TYPE_VIEW -> Optional.of(CatalogPrivilege.PRIVILEGE_VIEW_USAGE);
            case SecurableType.SECURABLE_TYPE_MATERIALIZED_VIEW -> Optional.of(CatalogPrivilege.PRIVILEGE_MATERIALIZED_VIEW_USAGE);
            case SecurableType.SECURABLE_TYPE_OBJECT_GROUP -> Optional.of(CatalogPrivilege.PRIVILEGE_OBJECT_GROUP_USAGE);
            case SecurableType.SECURABLE_TYPE_COMPUTE_ENGINE -> Optional.of(CatalogPrivilege.PRIVILEGE_COMPUTE_ENGINE_USAGE);
            case SecurableType.SECURABLE_TYPE_JOB -> Optional.of(CatalogPrivilege.PRIVILEGE_JOB_USAGE);
            case SecurableType.SECURABLE_TYPE_SECURITY_PROVIDER -> Optional.of(CatalogPrivilege.PRIVILEGE_SECURITY_PROVIDER_USAGE);
        };
    }

    public static Optional<CatalogPrivilege> usagePrivilege(SecurableType securableType) {
        return SECURABLE_TYPE_TO_PRIVILEGE.get((Object)securableType);
    }

    public static Set<CatalogPrivilege> effectiveUsagePrivileges(SecurableType securableType) {
        return SECURABLE_TYPE_TO_EFFECTIVE_PRIVILEGES.get((Object)securableType);
    }

    private SecurableTypeUsagePrivileges() {
    }

    static {
        EnumMap<SecurableType, Optional<CatalogPrivilege>> securableTypeToPrivilege = new EnumMap<SecurableType, Optional<CatalogPrivilege>>(SecurableType.class);
        EnumMap<SecurableType, Set<CatalogPrivilege>> securableTypeToEffectivePrivileges = new EnumMap<SecurableType, Set<CatalogPrivilege>>(SecurableType.class);
        for (SecurableType type : SecurableType.values()) {
            Optional<CatalogPrivilege> usagePrivilege = SecurableTypeUsagePrivileges.resolveUsagePrivilege(type);
            securableTypeToPrivilege.put(type, usagePrivilege);
            securableTypeToEffectivePrivileges.put(type, usagePrivilege.map(privilege -> CatalogPrivilege.collectEffectivePrivileges(Set.of(privilege))).orElse(Set.of()));
        }
        SECURABLE_TYPE_TO_PRIVILEGE = securableTypeToPrivilege;
        SECURABLE_TYPE_TO_EFFECTIVE_PRIVILEGES = securableTypeToEffectivePrivileges;
    }
}

