/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.security.authorization.securable;

import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import ru.cedrusdata.catalog.spi.exception.CatalogBadRequestException;

public enum SecurableType {
    SECURABLE_TYPE_METASTORE("metastore", Optional.empty()),
    SECURABLE_TYPE_PRINCIPAL("principal", Optional.of(SECURABLE_TYPE_METASTORE)),
    SECURABLE_TYPE_FILE_SYSTEM("file-system", Optional.of(SECURABLE_TYPE_METASTORE)),
    SECURABLE_TYPE_CATALOG("catalog", Optional.of(SECURABLE_TYPE_METASTORE)),
    SECURABLE_TYPE_NAMESPACE("namespace", Optional.of(SECURABLE_TYPE_CATALOG)),
    SECURABLE_TYPE_TABLE("table", Optional.of(SECURABLE_TYPE_NAMESPACE)),
    SECURABLE_TYPE_VIEW("view", Optional.of(SECURABLE_TYPE_NAMESPACE)),
    SECURABLE_TYPE_MATERIALIZED_VIEW("materialized-view", Optional.of(SECURABLE_TYPE_NAMESPACE)),
    SECURABLE_TYPE_OBJECT_GROUP("object-group", Optional.of(SECURABLE_TYPE_METASTORE)),
    SECURABLE_TYPE_COMPUTE_ENGINE("compute-engine", Optional.of(SECURABLE_TYPE_METASTORE)),
    SECURABLE_TYPE_JOB("job", Optional.of(SECURABLE_TYPE_COMPUTE_ENGINE)),
    SECURABLE_TYPE_SECURITY_PROVIDER("security-provider", Optional.of(SECURABLE_TYPE_METASTORE));

    private static final Map<String, SecurableType> CAPTION_TO_TYPE;
    private final String caption;
    private final Optional<SecurableType> parent;

    private SecurableType(String caption, Optional<SecurableType> parent) {
        this.caption = caption;
        this.parent = parent;
    }

    public String caption() {
        return this.caption;
    }

    public Optional<SecurableType> parent() {
        return this.parent;
    }

    public static SecurableType resolveByCaption(String caption) {
        if (caption != null) {
            caption = caption.trim().toLowerCase(Locale.ROOT);
        }
        if (caption == null || caption.isEmpty()) {
            throw new CatalogBadRequestException("Securable type cannot be empty");
        }
        SecurableType action = CAPTION_TO_TYPE.get(caption);
        if (action == null) {
            throw new CatalogBadRequestException("Unknown securable type action: " + caption);
        }
        return action;
    }

    static {
        ImmutableMap.Builder captionToActionBuilder = ImmutableMap.builder();
        for (SecurableType value : SecurableType.values()) {
            captionToActionBuilder.put((Object)value.caption(), (Object)value);
        }
        CAPTION_TO_TYPE = captionToActionBuilder.buildOrThrow();
    }
}

