/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.security.authorization;

import com.google.common.base.Verify;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import ru.cedrusdata.catalog.CatalogObjectNameValidation;
import ru.cedrusdata.catalog.core.computeengine.ComputeEngineService;
import ru.cedrusdata.catalog.core.filesystem.FileSystemService;
import ru.cedrusdata.catalog.core.maintenance.MaintenanceOperationService;
import ru.cedrusdata.catalog.core.objectgroup.ObjectGroupService;
import ru.cedrusdata.catalog.core.principal.AuthenticatedPrincipal;
import ru.cedrusdata.catalog.core.principal.AuthenticationContext;
import ru.cedrusdata.catalog.core.principal.PrincipalRoleIdService;
import ru.cedrusdata.catalog.core.principal.PrincipalService;
import ru.cedrusdata.catalog.core.security.authorization.Authorizer;
import ru.cedrusdata.catalog.core.security.authorization.AuthorizerObjectType;
import ru.cedrusdata.catalog.core.security.authorization.CatalogPrivilege;
import ru.cedrusdata.catalog.core.security.authorization.CatalogPrivilegedAction;
import ru.cedrusdata.catalog.core.security.authorization.PrivilegeInternalService;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationCheckResult;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationCheckResultStep;
import ru.cedrusdata.catalog.core.security.authorization.securable.InternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurableType;
import ru.cedrusdata.catalog.core.security.authorization.securable.UnboundSecurableInfo;
import ru.cedrusdata.catalog.core.security.provider.SecurityProviderService;
import ru.cedrusdata.catalog.iceberg.catalog.IcebergCatalogService;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceService;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableService;
import ru.cedrusdata.catalog.spi.exception.CatalogBadRequestException;
import ru.cedrusdata.catalog.spi.exception.CatalogUnsupportedOperationException;
import ru.cedrusdata.catalog.spi.model.AccessCheck;
import ru.cedrusdata.catalog.spi.model.CheckAccessRequest;
import ru.cedrusdata.catalog.spi.model.CheckAccessResponse;
import ru.cedrusdata.catalog.spi.model.GrantOwnershipRequest;
import ru.cedrusdata.catalog.spi.model.GrantPrivilegeRequest;
import ru.cedrusdata.catalog.spi.model.PrivilegeGrantInfo;
import ru.cedrusdata.catalog.spi.model.PrivilegeGrantsResponse;
import ru.cedrusdata.catalog.spi.model.PrivilegeTypeInfo;
import ru.cedrusdata.catalog.spi.model.PrivilegeTypesResponse;
import ru.cedrusdata.catalog.spi.model.PrivilegedActionInfo;
import ru.cedrusdata.catalog.spi.model.PrivilegedActionsResponse;
import ru.cedrusdata.catalog.spi.model.RevokePrivilegeRequest;
import ru.cedrusdata.catalog.spi.model.SecurablePrivilegeGrantsRequest;
import ru.cedrusdata.catalog.spi.model.SecurableTypeInfo;
import ru.cedrusdata.catalog.spi.model.SecurableTypesResponse;
import ru.cedrusdata.catalog.spi.model.UpdateResponse;

public class PrivilegeService {
    private final PrincipalService principalService;
    private final FileSystemService fileSystemService;
    private final IcebergCatalogService catalogService;
    private final IcebergNamespaceService namespaceService;
    private final IcebergTableService objectService;
    private final ObjectGroupService objectGroupService;
    private final ComputeEngineService computeEngineService;
    private final MaintenanceOperationService maintenanceOperationService;
    private final SecurityProviderService securityProviderService;
    private final PrivilegeInternalService privilegeService;
    private final PrincipalRoleIdService roleIdService;
    private final Authorizer authorizer;

    @Inject
    public PrivilegeService(PrincipalService principalService, FileSystemService fileSystemService, IcebergCatalogService catalogService, IcebergNamespaceService namespaceService, IcebergTableService objectService, ObjectGroupService objectGroupService, ComputeEngineService computeEngineService, MaintenanceOperationService maintenanceOperationService, PrivilegeInternalService privilegeService, PrincipalRoleIdService roleIdService, SecurityProviderService securityProviderService, Authorizer authorizer) {
        this.principalService = principalService;
        this.fileSystemService = fileSystemService;
        this.catalogService = catalogService;
        this.namespaceService = namespaceService;
        this.objectService = objectService;
        this.objectGroupService = objectGroupService;
        this.computeEngineService = computeEngineService;
        this.maintenanceOperationService = maintenanceOperationService;
        this.privilegeService = privilegeService;
        this.roleIdService = roleIdService;
        this.securityProviderService = securityProviderService;
        this.authorizer = authorizer;
    }

    public UpdateResponse grantPrivilege(AuthenticatedPrincipal principal, GrantPrivilegeRequest request) {
        String normalizedPrincipalName = CatalogObjectNameValidation.VALIDATION_PRINCIPAL.normalizeObjectName(request.getPrincipalName());
        UnboundSecurableInfo unboundSecurable = UnboundSecurableInfo.resolve(request.getSecurable());
        if (request.getPrivileges() == null || request.getPrivileges().isEmpty()) {
            throw new CatalogBadRequestException("No privileges provided");
        }
        Set<CatalogPrivilege> privileges = request.getPrivileges().stream().map(privilegeName -> CatalogPrivilege.resolveForSecurable(unboundSecurable.targetType(), privilegeName)).collect(Collectors.toSet());
        AuthenticatedPrincipal targetPrincipal = this.principalService.principal(normalizedPrincipalName);
        if (targetPrincipal.isUser()) {
            throw new CatalogBadRequestException("Privileges can be granted only to role");
        }
        if (PrincipalService.isBuiltinRole(normalizedPrincipalName) && !targetPrincipal.id().equals(this.roleIdService.publicRoleId())) {
            throw new CatalogBadRequestException(String.format("Cannot grant privileges to the built-in role \"%s\"", normalizedPrincipalName));
        }
        InternalSecurable boundSecurable = this.privilegeService.bindSecurable(unboundSecurable);
        this.authorizer.authorizePrivilegeGrant(principal, boundSecurable);
        boolean updated = this.privilegeService.createPrivileges(targetPrincipal.id(), privileges, boundSecurable, principal.id());
        return new UpdateResponse(Boolean.valueOf(updated));
    }

    public UpdateResponse revokePrivilege(AuthenticatedPrincipal principal, RevokePrivilegeRequest request) {
        String normalizedPrincipalName = CatalogObjectNameValidation.VALIDATION_PRINCIPAL.normalizeObjectName(request.getPrincipalName());
        UnboundSecurableInfo unboundSecurable = UnboundSecurableInfo.resolve(request.getSecurable());
        if (request.getPrivileges() == null || request.getPrivileges().isEmpty()) {
            throw new CatalogBadRequestException("No privileges provided");
        }
        Set<CatalogPrivilege> privileges = request.getPrivileges().stream().map(privilegeName -> CatalogPrivilege.resolveForSecurable(unboundSecurable.targetType(), privilegeName)).collect(Collectors.toSet());
        AuthenticatedPrincipal targetPrincipal = this.principalService.principal(normalizedPrincipalName);
        if (targetPrincipal.isUser()) {
            throw new CatalogBadRequestException("Privileges can be revoked only from role");
        }
        if (PrincipalService.isBuiltinRole(normalizedPrincipalName) && !targetPrincipal.id().equals(this.roleIdService.publicRoleId())) {
            throw new CatalogBadRequestException(String.format("Cannot revoke privileges from the built-in role \"%s\"", normalizedPrincipalName));
        }
        InternalSecurable boundSecurable = this.privilegeService.bindSecurable(unboundSecurable);
        this.authorizer.authorizePrivilegeRevoke(principal, boundSecurable);
        boolean updated = this.privilegeService.revokePrivileges(targetPrincipal.id(), privileges, boundSecurable);
        return new UpdateResponse(Boolean.valueOf(updated));
    }

    public PrivilegeGrantsResponse principalPrivilegeGrants(AuthenticatedPrincipal principal, String principalName) {
        String normalizedTargetPrincipalName = CatalogObjectNameValidation.VALIDATION_PRINCIPAL.normalizeObjectName(principalName);
        AuthenticatedPrincipal targetPrincipal = this.principalService.principal(normalizedTargetPrincipalName);
        this.authorizer.authorizePrivilegeListPrincipalGrants(principal, targetPrincipal.toSecurable());
        List<PrivilegeGrantInfo> grants = this.privilegeService.listPrincipalGrants(targetPrincipal.roleIds());
        return new PrivilegeGrantsResponse(grants);
    }

    public PrivilegeGrantsResponse securablePrivilegeGrants(AuthenticatedPrincipal principal, SecurablePrivilegeGrantsRequest request) {
        UnboundSecurableInfo unboundSecurable = UnboundSecurableInfo.resolve(request.getSecurable());
        InternalSecurable boundSecurable = this.privilegeService.bindSecurable(unboundSecurable);
        this.authorizer.authorizePrivilegeListSecurableGrants(principal, boundSecurable);
        Set<CatalogPrivilege> privileges = CatalogPrivilege.applicablePrivileges(boundSecurable.type());
        HashSet<UUID> securableIds = new HashSet<UUID>();
        boundSecurable.collect((type, item) -> securableIds.add(item.id()));
        List<PrivilegeGrantInfo> grants = this.privilegeService.listSecurableGrants(securableIds, privileges);
        return new PrivilegeGrantsResponse(grants);
    }

    public UpdateResponse grantOwnership(AuthenticatedPrincipal principal, GrantOwnershipRequest request) {
        UnboundSecurableInfo unboundSecurable = UnboundSecurableInfo.resolve(request.getSecurable());
        if (unboundSecurable.parentType() != unboundSecurable.targetType()) {
            throw new CatalogUnsupportedOperationException("Bulk ownership update is not supported yet");
        }
        AuthenticatedPrincipal newOwnerPrincipal = this.principalService.principal(request.getNewOwnerName());
        boolean updated = switch (unboundSecurable.targetType()) {
            default -> throw new MatchException(null, null);
            case SecurableType.SECURABLE_TYPE_METASTORE -> throw new CatalogBadRequestException("Cannot change metastore owner");
            case SecurableType.SECURABLE_TYPE_PRINCIPAL -> this.principalService.grantOwnership(principal, unboundSecurable.name(0), newOwnerPrincipal);
            case SecurableType.SECURABLE_TYPE_FILE_SYSTEM -> this.fileSystemService.grantOwnership(principal, unboundSecurable.name(0), newOwnerPrincipal);
            case SecurableType.SECURABLE_TYPE_CATALOG -> this.catalogService.grantOwnership(principal, unboundSecurable.name(0), newOwnerPrincipal);
            case SecurableType.SECURABLE_TYPE_NAMESPACE -> this.namespaceService.grantOwnership(principal, unboundSecurable.name(0), unboundSecurable.name(1), newOwnerPrincipal);
            case SecurableType.SECURABLE_TYPE_TABLE -> this.objectService.grantOwnership(principal, unboundSecurable.name(0), unboundSecurable.name(1), unboundSecurable.name(2), AuthorizerObjectType.TABLE, newOwnerPrincipal);
            case SecurableType.SECURABLE_TYPE_VIEW -> this.objectService.grantOwnership(principal, unboundSecurable.name(0), unboundSecurable.name(1), unboundSecurable.name(2), AuthorizerObjectType.VIEW, newOwnerPrincipal);
            case SecurableType.SECURABLE_TYPE_MATERIALIZED_VIEW -> this.objectService.grantOwnership(principal, unboundSecurable.name(0), unboundSecurable.name(1), unboundSecurable.name(2), AuthorizerObjectType.MATERIALIZED_VIEW, newOwnerPrincipal);
            case SecurableType.SECURABLE_TYPE_OBJECT_GROUP -> this.objectGroupService.grantOwnership(principal, unboundSecurable.name(0), newOwnerPrincipal);
            case SecurableType.SECURABLE_TYPE_COMPUTE_ENGINE -> this.computeEngineService.grantOwnership(principal, unboundSecurable.name(0), newOwnerPrincipal);
            case SecurableType.SECURABLE_TYPE_JOB -> {
                Verify.verify((unboundSecurable.names().size() == 1 || unboundSecurable.names().size() == 2 ? 1 : 0) != 0);
                Optional<String> engineName = unboundSecurable.names().size() == 2 ? Optional.of(unboundSecurable.name(0)) : Optional.empty();
                String jobName = unboundSecurable.names().getLast();
                yield this.maintenanceOperationService.grantJobOwnership(principal, engineName, jobName, newOwnerPrincipal);
            }
            case SecurableType.SECURABLE_TYPE_SECURITY_PROVIDER -> this.securityProviderService.grantOwnership(principal, unboundSecurable.name(0), newOwnerPrincipal);
        };
        return new UpdateResponse(Boolean.valueOf(updated));
    }

    public SecurableTypesResponse securableTypes() {
        ArrayList<SecurableTypeInfo> infos = new ArrayList<SecurableTypeInfo>();
        for (SecurableType type : SecurableType.values()) {
            infos.add(new SecurableTypeInfo(type.caption(), (String)type.parent().map(SecurableType::caption).orElse(null)));
        }
        return new SecurableTypesResponse(infos);
    }

    public PrivilegeTypesResponse privilegeTypes() {
        ArrayList<PrivilegeTypeInfo> infos = new ArrayList<PrivilegeTypeInfo>();
        for (CatalogPrivilege privilege : CatalogPrivilege.values()) {
            infos.add(new PrivilegeTypeInfo(privilege.caption(), privilege.securableType().caption(), privilege.getImpliedPrivileges().stream().map(CatalogPrivilege::caption).collect(Collectors.toSet())));
        }
        return new PrivilegeTypesResponse(infos);
    }

    public PrivilegedActionsResponse privilegedActions() {
        ArrayList<PrivilegedActionInfo> infos = new ArrayList<PrivilegedActionInfo>();
        for (CatalogPrivilegedAction action : CatalogPrivilegedAction.values()) {
            infos.add(new PrivilegedActionInfo(action.caption(), (String)action.getSecurableType().map(SecurableType::caption).orElse(null)));
        }
        return new PrivilegedActionsResponse(infos);
    }

    public CheckAccessResponse checkAccess(AuthenticationContext context, CheckAccessRequest request) {
        AuthenticationContext targetContext = context;
        if (request.getPrincipalName() != null) {
            AuthenticatedPrincipal principal = this.principalService.principal(request.getPrincipalName());
            targetContext = this.principalService.impersonate(context, principal);
        }
        CatalogPrivilegedAction action = CatalogPrivilegedAction.resolveByCaption(request.getAction());
        UnboundSecurableInfo unboundSecurable = UnboundSecurableInfo.resolve(request.getSecurable());
        InternalSecurable boundSecurable = this.privilegeService.bindSecurable(unboundSecurable);
        if (action.getSecurableType().isPresent() && !action.getSecurableType().get().equals((Object)boundSecurable.type())) {
            throw new CatalogBadRequestException(String.format("Privileged action \"%s\" cannot be applied to securable \"%s\"", action.caption(), boundSecurable.type().caption()));
        }
        AuthorizationCheckResult result = this.authorizer.checkAccess(targetContext.subject(), action, boundSecurable);
        AccessCheck rootCheck = PrivilegeService.convertAccessCheck(result.rootCheck(), boundSecurable);
        return new CheckAccessResponse(rootCheck);
    }

    private static AccessCheck convertAccessCheck(AuthorizationCheckResultStep internalCheck, InternalSecurable securable) {
        AccessCheck.Builder builder = AccessCheck.newBuilder();
        builder.setAllowed(Boolean.valueOf(internalCheck.allowed()));
        builder.setDescriptor(internalCheck.check().descriptor(securable));
        List<AccessCheck> childChecks = internalCheck.children().stream().map(child -> PrivilegeService.convertAccessCheck(child, securable)).toList();
        if (!childChecks.isEmpty()) {
            builder.setChildChecks(childChecks);
        }
        return builder.build();
    }
}

