/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.security.authorization;

import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import ru.cedrusdata.catalog.core.security.authorization.CatalogPrivilege;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationCheckExecutor;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationCheckExecutorBuilder;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurableType;
import ru.cedrusdata.catalog.spi.exception.CatalogAuthorizationException;
import ru.cedrusdata.catalog.spi.exception.CatalogBadRequestException;

public enum CatalogPrivilegedAction {
    ACTION_READ_METRICS("read-metrics", Optional.of(SecurableType.SECURABLE_TYPE_METASTORE), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_MANAGEMENT_READ)),
    ACTION_PRINCIPAL_CREATE("principal.create", Optional.of(SecurableType.SECURABLE_TYPE_METASTORE), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_PRINCIPAL_CREATE)),
    ACTION_PRINCIPAL_ALTER("principal.alter", Optional.of(SecurableType.SECURABLE_TYPE_PRINCIPAL), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_PRINCIPAL_ALTER)),
    ACTION_PRINCIPAL_DROP("principal.drop", Optional.of(SecurableType.SECURABLE_TYPE_PRINCIPAL), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_PRINCIPAL_DROP)),
    ACTION_PRINCIPAL_IMPERSONATE("principal.impersonate", Optional.of(SecurableType.SECURABLE_TYPE_PRINCIPAL), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_PRINCIPAL_IMPERSONATE)),
    ACTION_PRINCIPAL_DESCRIBE("principal.describe", Optional.of(SecurableType.SECURABLE_TYPE_PRINCIPAL), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_PRINCIPAL_USAGE)),
    ACTION_PRINCIPAL_LIST("principal.list", Optional.of(SecurableType.SECURABLE_TYPE_METASTORE), new AuthorizationCheckExecutorBuilder().allowForPublic()),
    ACTION_PRINCIPAL_CREATE_ACCESS_TOKEN("principal.create-access-token", Optional.of(SecurableType.SECURABLE_TYPE_PRINCIPAL), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_PRINCIPAL_MANAGE_ACCESS_TOKENS)),
    ACTION_PRINCIPAL_DROP_ACCESS_TOKEN("principal.drop-access-token", Optional.of(SecurableType.SECURABLE_TYPE_PRINCIPAL), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_PRINCIPAL_MANAGE_ACCESS_TOKENS)),
    ACTION_PRINCIPAL_LIST_ACCESS_TOKENS("principal.list-access-tokens", Optional.of(SecurableType.SECURABLE_TYPE_METASTORE), new AuthorizationCheckExecutorBuilder().allowForPublic()),
    ACTION_ROLE_GRANT("role.grant", Optional.of(SecurableType.SECURABLE_TYPE_PRINCIPAL), new AuthorizationCheckExecutorBuilder().allowForManageGrants()),
    ACTION_ROLE_REVOKE("role.revoke", Optional.of(SecurableType.SECURABLE_TYPE_PRINCIPAL), new AuthorizationCheckExecutorBuilder().allowForManageGrants()),
    ACTION_ROLE_LIST_MEMBERS("role.list-members", Optional.of(SecurableType.SECURABLE_TYPE_PRINCIPAL), new AuthorizationCheckExecutorBuilder().allowForManageGrants()),
    ACTION_PRIVILEGE_GRANT("privilege.grant", Optional.empty(), new AuthorizationCheckExecutorBuilder().allowForManageGrants()),
    ACTION_PRIVILEGE_REVOKE("privilege.revoke", Optional.empty(), new AuthorizationCheckExecutorBuilder().allowForManageGrants()),
    ACTION_PRIVILEGE_LIST_PRINCIPAL_GRANTS("privilege.list-principal-grants", Optional.of(SecurableType.SECURABLE_TYPE_PRINCIPAL), new AuthorizationCheckExecutorBuilder().allowForManageGrants()),
    ACTION_PRIVILEGE_LIST_SECURABLE_GRANTS("privilege.list-securable-grants", Optional.empty(), new AuthorizationCheckExecutorBuilder().allowForManageGrants()),
    ACTION_GRANT_OWNERSHIP("grant-ownership", Optional.empty(), new AuthorizationCheckExecutorBuilder()),
    ACTION_FILE_SYSTEM_CREATE("file-system.create", Optional.of(SecurableType.SECURABLE_TYPE_METASTORE), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_FILE_SYSTEM_CREATE)),
    ACTION_FILE_SYSTEM_ALTER("file-system.alter", Optional.of(SecurableType.SECURABLE_TYPE_FILE_SYSTEM), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_FILE_SYSTEM_ALTER)),
    ACTION_FILE_SYSTEM_DROP("file-system.drop", Optional.of(SecurableType.SECURABLE_TYPE_FILE_SYSTEM), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_FILE_SYSTEM_DROP)),
    ACTION_FILE_SYSTEM_CHECK("file-system.check", Optional.of(SecurableType.SECURABLE_TYPE_FILE_SYSTEM), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_FILE_SYSTEM_USAGE)),
    ACTION_FILE_SYSTEM_DESCRIBE("file-system.describe", Optional.of(SecurableType.SECURABLE_TYPE_FILE_SYSTEM), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_FILE_SYSTEM_USAGE)),
    ACTION_FILE_SYSTEM_LIST("file-system.list", Optional.of(SecurableType.SECURABLE_TYPE_METASTORE), new AuthorizationCheckExecutorBuilder().allowForPublic()),
    ACTION_CATALOG_CREATE("catalog.create", Optional.of(SecurableType.SECURABLE_TYPE_METASTORE), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_CATALOG_CREATE)),
    ACTION_CATALOG_ALTER("catalog.alter", Optional.of(SecurableType.SECURABLE_TYPE_CATALOG), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_CATALOG_ALTER)),
    ACTION_CATALOG_DROP("catalog.drop", Optional.of(SecurableType.SECURABLE_TYPE_CATALOG), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_CATALOG_DROP)),
    ACTION_CATALOG_CHECK("catalog.check", Optional.of(SecurableType.SECURABLE_TYPE_CATALOG), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_CATALOG_USAGE)),
    ACTION_CATALOG_DESCRIBE("catalog.describe", Optional.of(SecurableType.SECURABLE_TYPE_CATALOG), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_CATALOG_USAGE)),
    ACTION_CATALOG_LIST("catalog.list", Optional.of(SecurableType.SECURABLE_TYPE_METASTORE), new AuthorizationCheckExecutorBuilder().allowForPublic()),
    ACTION_NAMESPACE_CREATE("namespace.create", Optional.of(SecurableType.SECURABLE_TYPE_CATALOG), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_NAMESPACE_CREATE)),
    ACTION_NAMESPACE_ALTER("namespace.alter", Optional.of(SecurableType.SECURABLE_TYPE_NAMESPACE), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_NAMESPACE_ALTER)),
    ACTION_NAMESPACE_DROP("namespace.drop", Optional.of(SecurableType.SECURABLE_TYPE_NAMESPACE), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_NAMESPACE_DROP)),
    ACTION_NAMESPACE_DESCRIBE("namespace.describe", Optional.of(SecurableType.SECURABLE_TYPE_NAMESPACE), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_NAMESPACE_USAGE)),
    ACTION_NAMESPACE_LIST("namespace.list", Optional.of(SecurableType.SECURABLE_TYPE_METASTORE), new AuthorizationCheckExecutorBuilder().allowForPublic()),
    ACTION_TABLE_CREATE("table.create", Optional.of(SecurableType.SECURABLE_TYPE_NAMESPACE), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_TABLE_CREATE)),
    ACTION_TABLE_ALTER("table.alter", Optional.of(SecurableType.SECURABLE_TYPE_TABLE), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_TABLE_ALTER)),
    ACTION_TABLE_DROP("table.drop", Optional.of(SecurableType.SECURABLE_TYPE_TABLE), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_TABLE_DROP)),
    ACTION_TABLE_DESCRIBE("table.describe", Optional.of(SecurableType.SECURABLE_TYPE_TABLE), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_TABLE_USAGE)),
    ACTION_TABLE_MODIFY("table.modify", Optional.of(SecurableType.SECURABLE_TYPE_TABLE), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_TABLE_MODIFY)),
    ACTION_VIEW_CREATE("view.create", Optional.of(SecurableType.SECURABLE_TYPE_NAMESPACE), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_VIEW_CREATE)),
    ACTION_VIEW_ALTER("view.alter", Optional.of(SecurableType.SECURABLE_TYPE_VIEW), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_VIEW_ALTER)),
    ACTION_VIEW_DROP("view.drop", Optional.of(SecurableType.SECURABLE_TYPE_VIEW), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_VIEW_DROP)),
    ACTION_VIEW_DESCRIBE("view.describe", Optional.of(SecurableType.SECURABLE_TYPE_VIEW), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_VIEW_USAGE)),
    ACTION_MATERIALIZED_VIEW_CREATE("materialized-view.create", Optional.of(SecurableType.SECURABLE_TYPE_NAMESPACE), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_MATERIALIZED_VIEW_CREATE)),
    ACTION_MATERIALIZED_VIEW_ALTER("materialized-view.alter", Optional.of(SecurableType.SECURABLE_TYPE_MATERIALIZED_VIEW), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_MATERIALIZED_VIEW_ALTER)),
    ACTION_MATERIALIZED_VIEW_DROP("materialized-view.drop", Optional.of(SecurableType.SECURABLE_TYPE_MATERIALIZED_VIEW), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_MATERIALIZED_VIEW_DROP)),
    ACTION_MATERIALIZED_VIEW_DESCRIBE("materialized-view.describe", Optional.of(SecurableType.SECURABLE_TYPE_MATERIALIZED_VIEW), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_MATERIALIZED_VIEW_USAGE)),
    ACTION_MATERIALIZED_VIEW_MODIFY("materialized-view.modify", Optional.of(SecurableType.SECURABLE_TYPE_MATERIALIZED_VIEW), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_MATERIALIZED_VIEW_MODIFY)),
    ACTION_OBJECT_LIST("object.list", Optional.of(SecurableType.SECURABLE_TYPE_METASTORE), new AuthorizationCheckExecutorBuilder().allowForPublic()),
    ACTION_OBJECT_GROUP_CREATE("object-group.create", Optional.of(SecurableType.SECURABLE_TYPE_METASTORE), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_OBJECT_GROUP_CREATE)),
    ACTION_OBJECT_GROUP_ALTER("object-group.alter", Optional.of(SecurableType.SECURABLE_TYPE_OBJECT_GROUP), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_OBJECT_GROUP_ALTER)),
    ACTION_OBJECT_GROUP_DROP("object-group.drop", Optional.of(SecurableType.SECURABLE_TYPE_OBJECT_GROUP), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_OBJECT_GROUP_DROP)),
    ACTION_OBJECT_GROUP_DESCRIBE("object-group.describe", Optional.of(SecurableType.SECURABLE_TYPE_OBJECT_GROUP), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_OBJECT_GROUP_USAGE)),
    ACTION_OBJECT_GROUP_LIST("object-group.list", Optional.of(SecurableType.SECURABLE_TYPE_METASTORE), new AuthorizationCheckExecutorBuilder().allowForPublic()),
    ACTION_OBJECT_GROUP_LIST_OBJECTS("object-group.list-objects", Optional.of(SecurableType.SECURABLE_TYPE_METASTORE), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_OBJECT_GROUP_USAGE)),
    ACTION_COMPUTE_ENGINE_CREATE("compute-engine.create", Optional.of(SecurableType.SECURABLE_TYPE_METASTORE), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_COMPUTE_ENGINE_CREATE)),
    ACTION_COMPUTE_ENGINE_LIST("compute-engine.list", Optional.of(SecurableType.SECURABLE_TYPE_METASTORE), new AuthorizationCheckExecutorBuilder().allowForPublic()),
    ACTION_COMPUTE_ENGINE_LIST_OPERATIONS("compute-engine.list-operations", Optional.of(SecurableType.SECURABLE_TYPE_METASTORE), new AuthorizationCheckExecutorBuilder().allowForPublic()),
    ACTION_COMPUTE_ENGINE_ALTER("compute-engine.alter", Optional.of(SecurableType.SECURABLE_TYPE_COMPUTE_ENGINE), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_COMPUTE_ENGINE_ALTER)),
    ACTION_COMPUTE_ENGINE_DROP("compute-engine.drop", Optional.of(SecurableType.SECURABLE_TYPE_COMPUTE_ENGINE), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_COMPUTE_ENGINE_DROP)),
    ACTION_COMPUTE_ENGINE_CHECK("compute-engine.check", Optional.of(SecurableType.SECURABLE_TYPE_COMPUTE_ENGINE), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_COMPUTE_ENGINE_USAGE)),
    ACTION_COMPUTE_ENGINE_DESCRIBE("compute-engine.describe", Optional.of(SecurableType.SECURABLE_TYPE_COMPUTE_ENGINE), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_COMPUTE_ENGINE_USAGE)),
    ACTION_COMPUTE_ENGINE_START_OPERATION("compute-engine.start-operation", Optional.of(SecurableType.SECURABLE_TYPE_COMPUTE_ENGINE), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_COMPUTE_ENGINE_USAGE)),
    ACTION_COMPUTE_ENGINE_CANCEL_OPERATION("compute-engine.cancel-operation", Optional.of(SecurableType.SECURABLE_TYPE_COMPUTE_ENGINE), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_COMPUTE_ENGINE_USAGE)),
    ACTION_JOB_CREATE("job.create", Optional.of(SecurableType.SECURABLE_TYPE_COMPUTE_ENGINE), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_JOB_CREATE)),
    ACTION_JOB_LIST("job.list", Optional.of(SecurableType.SECURABLE_TYPE_METASTORE), new AuthorizationCheckExecutorBuilder().allowForPublic()),
    ACTION_JOB_ALTER("job.alter", Optional.of(SecurableType.SECURABLE_TYPE_JOB), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_JOB_ALTER)),
    ACTION_JOB_DROP("job.drop", Optional.of(SecurableType.SECURABLE_TYPE_JOB), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_JOB_DROP)),
    ACTION_JOB_DESCRIBE("job.describe", Optional.of(SecurableType.SECURABLE_TYPE_JOB), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_JOB_USAGE)),
    ACTION_SECURITY_PROVIDER_CREATE("security-provider.create", Optional.of(SecurableType.SECURABLE_TYPE_METASTORE), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_SECURITY_PROVIDER_CREATE)),
    ACTION_SECURITY_PROVIDER_LIST("security-provider.list", Optional.of(SecurableType.SECURABLE_TYPE_METASTORE), new AuthorizationCheckExecutorBuilder().allowForPublic()),
    ACTION_SECURITY_PROVIDER_ALTER("security-provider.alter", Optional.of(SecurableType.SECURABLE_TYPE_SECURITY_PROVIDER), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_SECURITY_PROVIDER_ALTER)),
    ACTION_SECURITY_PROVIDER_DROP("security-provider.drop", Optional.of(SecurableType.SECURABLE_TYPE_SECURITY_PROVIDER), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_SECURITY_PROVIDER_DROP)),
    ACTION_SECURITY_PROVIDER_CHECK("security-provider.check", Optional.of(SecurableType.SECURABLE_TYPE_SECURITY_PROVIDER), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_SECURITY_PROVIDER_USAGE)),
    ACTION_SECURITY_PROVIDER_DESCRIBE("security-provider.describe", Optional.of(SecurableType.SECURABLE_TYPE_SECURITY_PROVIDER), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_SECURITY_PROVIDER_USAGE)),
    ACTION_SECURITY_PROVIDER_USE("security-provider.use", Optional.of(SecurableType.SECURABLE_TYPE_SECURITY_PROVIDER), new AuthorizationCheckExecutorBuilder().allowForPrivilege(CatalogPrivilege.PRIVILEGE_SECURITY_PROVIDER_USAGE));

    private static final Map<String, CatalogPrivilegedAction> CAPTION_TO_ACTION;
    private final String caption;
    private final Optional<SecurableType> securableType;
    private final AuthorizationCheckExecutor executor;

    private CatalogPrivilegedAction(String caption, Optional<SecurableType> securableType, AuthorizationCheckExecutorBuilder executorBuilder) {
        this.caption = caption;
        this.securableType = securableType;
        this.executor = executorBuilder.build(this);
    }

    public String caption() {
        return this.caption;
    }

    public Optional<SecurableType> getSecurableType() {
        return this.securableType;
    }

    public AuthorizationCheckExecutor executor() {
        return this.executor;
    }

    public CatalogAuthorizationException createAuthorizationException(String principalName) {
        return new CatalogAuthorizationException(principalName, this.caption);
    }

    public static CatalogPrivilegedAction resolveByCaption(String caption) {
        if (caption != null) {
            caption = caption.trim().toLowerCase(Locale.ROOT);
        }
        if (caption == null || caption.isEmpty()) {
            throw new CatalogBadRequestException("Privileged action name cannot be empty");
        }
        CatalogPrivilegedAction action = CAPTION_TO_ACTION.get(caption);
        if (action == null) {
            throw new CatalogBadRequestException("Unknown privileged action: " + caption);
        }
        return action;
    }

    static {
        ImmutableMap.Builder captionToActionBuilder = ImmutableMap.builder();
        for (CatalogPrivilegedAction value : CatalogPrivilegedAction.values()) {
            captionToActionBuilder.put((Object)value.caption(), (Object)value);
        }
        CAPTION_TO_ACTION = captionToActionBuilder.buildOrThrow();
    }
}

