/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.security.authorization;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurableType;
import ru.cedrusdata.catalog.spi.exception.CatalogBadRequestException;
import ru.cedrusdata.catalog.spi.exception.CatalogInternalServerErrorException;

public enum CatalogPrivilege {
    PRIVILEGE_MANAGE_GRANTS(UUID.fromString("dfa4ddd7-cc84-4257-811d-fc0631be6fc7"), SecurableType.SECURABLE_TYPE_METASTORE, "manage-grants", Set.of()),
    PRIVILEGE_MANAGEMENT_READ(UUID.fromString("e034a29a-f549-4033-9695-1a6041163793"), SecurableType.SECURABLE_TYPE_METASTORE, "management-read", Set.of()),
    PRIVILEGE_PRINCIPAL_CREATE(UUID.fromString("208f70bc-fe77-458a-8df8-32c479fa6eb9"), SecurableType.SECURABLE_TYPE_METASTORE, "principal.create", Set.of()),
    PRIVILEGE_PRINCIPAL_USAGE(UUID.fromString("d1a677db-08c0-40e7-b537-f27a6a98bc77"), SecurableType.SECURABLE_TYPE_PRINCIPAL, "principal.usage", Set.of()),
    PRIVILEGE_PRINCIPAL_ALTER(UUID.fromString("c939b0e1-ea25-4d0b-9cab-43ea8f23d790"), SecurableType.SECURABLE_TYPE_PRINCIPAL, "principal.alter", Set.of(PRIVILEGE_PRINCIPAL_USAGE)),
    PRIVILEGE_PRINCIPAL_DROP(UUID.fromString("ec8440de-fd1b-4d78-ad1e-2450ba3c8e84"), SecurableType.SECURABLE_TYPE_PRINCIPAL, "principal.drop", Set.of(PRIVILEGE_PRINCIPAL_USAGE)),
    PRIVILEGE_PRINCIPAL_IMPERSONATE(UUID.fromString("0d401df2-1f1c-4123-a1ed-59cd0945c7f9"), SecurableType.SECURABLE_TYPE_PRINCIPAL, "principal.impersonate", Set.of(PRIVILEGE_PRINCIPAL_USAGE)),
    PRIVILEGE_PRINCIPAL_MANAGE_ACCESS_TOKENS(UUID.fromString("a1e4e3c5-d11c-44fc-836f-615f59543fa8"), SecurableType.SECURABLE_TYPE_PRINCIPAL, "principal.manage-access-tokens", Set.of(PRIVILEGE_PRINCIPAL_USAGE)),
    PRIVILEGE_FILE_SYSTEM_CREATE(UUID.fromString("22cdf370-73fb-4be6-86de-aa0e24cfc3dc"), SecurableType.SECURABLE_TYPE_METASTORE, "file-system.create", Set.of()),
    PRIVILEGE_FILE_SYSTEM_USAGE(UUID.fromString("1b50556b-4c8e-4fa6-9b7b-85a07b48bdbb"), SecurableType.SECURABLE_TYPE_FILE_SYSTEM, "file-system.usage", Set.of()),
    PRIVILEGE_FILE_SYSTEM_ALTER(UUID.fromString("7e12a10f-cc79-4adf-8dea-44fa725ba479"), SecurableType.SECURABLE_TYPE_FILE_SYSTEM, "file-system.alter", Set.of(PRIVILEGE_FILE_SYSTEM_USAGE)),
    PRIVILEGE_FILE_SYSTEM_DROP(UUID.fromString("a8300dc2-21c1-47de-9086-39a11b341a7c"), SecurableType.SECURABLE_TYPE_FILE_SYSTEM, "file-system.drop", Set.of(PRIVILEGE_FILE_SYSTEM_USAGE)),
    PRIVILEGE_CATALOG_CREATE(UUID.fromString("684aad44-5961-437c-8145-0bf6401854b3"), SecurableType.SECURABLE_TYPE_METASTORE, "catalog.create", Set.of()),
    PRIVILEGE_CATALOG_USAGE(UUID.fromString("55c36f3a-d2b4-4b42-9bf2-30de2b724630"), SecurableType.SECURABLE_TYPE_CATALOG, "catalog.usage", Set.of()),
    PRIVILEGE_CATALOG_ALTER(UUID.fromString("21553838-5b19-481e-b8c3-089290f2b98a"), SecurableType.SECURABLE_TYPE_CATALOG, "catalog.alter", Set.of(PRIVILEGE_CATALOG_USAGE)),
    PRIVILEGE_CATALOG_DROP(UUID.fromString("4317509c-eeb7-4c11-9d23-6c44086a4de1"), SecurableType.SECURABLE_TYPE_CATALOG, "catalog.drop", Set.of(PRIVILEGE_CATALOG_USAGE)),
    PRIVILEGE_NAMESPACE_CREATE(UUID.fromString("6f3cbb67-576f-45bb-8aca-dc94e83aa93d"), SecurableType.SECURABLE_TYPE_CATALOG, "namespace.create", Set.of(PRIVILEGE_CATALOG_USAGE)),
    PRIVILEGE_NAMESPACE_USAGE(UUID.fromString("45c42b99-383d-4304-9f6b-c5580ff3fa39"), SecurableType.SECURABLE_TYPE_NAMESPACE, "namespace.usage", Set.of()),
    PRIVILEGE_NAMESPACE_ALTER(UUID.fromString("d0291694-1756-4b62-b450-c60277334c21"), SecurableType.SECURABLE_TYPE_NAMESPACE, "namespace.alter", Set.of(PRIVILEGE_NAMESPACE_USAGE)),
    PRIVILEGE_NAMESPACE_DROP(UUID.fromString("cf3b404b-60de-44a6-a680-81722fbf273a"), SecurableType.SECURABLE_TYPE_NAMESPACE, "namespace.drop", Set.of(PRIVILEGE_NAMESPACE_USAGE)),
    PRIVILEGE_TABLE_CREATE(UUID.fromString("9879f63b-30d5-4c1b-875f-0154d1d8efd1"), SecurableType.SECURABLE_TYPE_NAMESPACE, "table.create", Set.of(PRIVILEGE_NAMESPACE_USAGE)),
    PRIVILEGE_TABLE_USAGE(UUID.fromString("3005ea71-e5f4-4fe6-8d0b-bf8b0e7c7548"), SecurableType.SECURABLE_TYPE_TABLE, "table.usage", Set.of()),
    PRIVILEGE_TABLE_ALTER(UUID.fromString("d11df7d6-2667-477b-b697-b35011ec3169"), SecurableType.SECURABLE_TYPE_TABLE, "table.alter", Set.of(PRIVILEGE_TABLE_USAGE)),
    PRIVILEGE_TABLE_DROP(UUID.fromString("917f1e0b-99ff-4a66-802b-9f1d799963bc"), SecurableType.SECURABLE_TYPE_TABLE, "table.drop", Set.of(PRIVILEGE_TABLE_USAGE)),
    PRIVILEGE_TABLE_MODIFY(UUID.fromString("9b7873f3-e02d-419d-bca0-efaed1c715c7"), SecurableType.SECURABLE_TYPE_TABLE, "table.modify", Set.of(PRIVILEGE_TABLE_USAGE)),
    PRIVILEGE_VIEW_CREATE(UUID.fromString("40475128-992c-4356-9fb2-09b40e0dc203"), SecurableType.SECURABLE_TYPE_NAMESPACE, "view.create", Set.of(PRIVILEGE_NAMESPACE_USAGE)),
    PRIVILEGE_VIEW_USAGE(UUID.fromString("09698225-e978-4b0e-b921-b9250103de0c"), SecurableType.SECURABLE_TYPE_VIEW, "view.usage", Set.of()),
    PRIVILEGE_VIEW_ALTER(UUID.fromString("dc751164-605f-4000-b8d3-f6813f0f5b87"), SecurableType.SECURABLE_TYPE_VIEW, "view.alter", Set.of(PRIVILEGE_VIEW_USAGE)),
    PRIVILEGE_VIEW_DROP(UUID.fromString("472ca0f0-8b1d-465d-8d71-497f232d7a47"), SecurableType.SECURABLE_TYPE_VIEW, "view.drop", Set.of(PRIVILEGE_VIEW_USAGE)),
    PRIVILEGE_MATERIALIZED_VIEW_CREATE(UUID.fromString("ce9f0032-2e62-47b6-aa00-21b0f84d3aa0"), SecurableType.SECURABLE_TYPE_NAMESPACE, "materialized-view.create", Set.of(PRIVILEGE_NAMESPACE_USAGE)),
    PRIVILEGE_MATERIALIZED_VIEW_USAGE(UUID.fromString("caf7a5a6-0b5c-4afa-b6a2-10a14b050839"), SecurableType.SECURABLE_TYPE_MATERIALIZED_VIEW, "materialized-view.usage", Set.of()),
    PRIVILEGE_MATERIALIZED_VIEW_ALTER(UUID.fromString("1504aad7-bbdc-4e6e-8b61-87b05e647281"), SecurableType.SECURABLE_TYPE_MATERIALIZED_VIEW, "materialized-view.alter", Set.of(PRIVILEGE_MATERIALIZED_VIEW_USAGE)),
    PRIVILEGE_MATERIALIZED_VIEW_DROP(UUID.fromString("c2551fc6-b0eb-4cd9-bb69-dffb2eed158d"), SecurableType.SECURABLE_TYPE_MATERIALIZED_VIEW, "materialized-view.drop", Set.of(PRIVILEGE_MATERIALIZED_VIEW_USAGE)),
    PRIVILEGE_MATERIALIZED_VIEW_MODIFY(UUID.fromString("55fe62da-ff22-4707-86d9-302652167626"), SecurableType.SECURABLE_TYPE_MATERIALIZED_VIEW, "materialized-view.modify", Set.of(PRIVILEGE_MATERIALIZED_VIEW_USAGE)),
    PRIVILEGE_OBJECT_GROUP_CREATE(UUID.fromString("a778072d-b08a-4170-82eb-200eac18a3eb"), SecurableType.SECURABLE_TYPE_METASTORE, "object-group.create", Set.of()),
    PRIVILEGE_OBJECT_GROUP_USAGE(UUID.fromString("7e690e1e-d11d-4b8b-b241-072bdb74bdd3"), SecurableType.SECURABLE_TYPE_OBJECT_GROUP, "object-group.usage", Set.of()),
    PRIVILEGE_OBJECT_GROUP_ALTER(UUID.fromString("940abff8-fac5-41ee-9bc0-415857a47f69"), SecurableType.SECURABLE_TYPE_OBJECT_GROUP, "object-group.alter", Set.of(PRIVILEGE_OBJECT_GROUP_USAGE)),
    PRIVILEGE_OBJECT_GROUP_DROP(UUID.fromString("0f0a76c9-a902-49d7-98e0-cc3c199451f0"), SecurableType.SECURABLE_TYPE_OBJECT_GROUP, "object-group.drop", Set.of(PRIVILEGE_OBJECT_GROUP_USAGE)),
    PRIVILEGE_COMPUTE_ENGINE_CREATE(UUID.fromString("38b7b73b-0e6f-4d65-b48a-e67a390f14e1"), SecurableType.SECURABLE_TYPE_METASTORE, "compute-engine.create", Set.of()),
    PRIVILEGE_COMPUTE_ENGINE_USAGE(UUID.fromString("66dd9963-3a36-4e39-a2be-3b4991d9b3fc"), SecurableType.SECURABLE_TYPE_COMPUTE_ENGINE, "compute-engine.usage", Set.of()),
    PRIVILEGE_COMPUTE_ENGINE_ALTER(UUID.fromString("6129abf0-31df-4a98-8fde-de5dad01629d"), SecurableType.SECURABLE_TYPE_COMPUTE_ENGINE, "compute-engine.alter", Set.of(PRIVILEGE_COMPUTE_ENGINE_USAGE)),
    PRIVILEGE_COMPUTE_ENGINE_DROP(UUID.fromString("e9de7236-f38b-45be-a254-607ff0a3f5a0"), SecurableType.SECURABLE_TYPE_COMPUTE_ENGINE, "compute-engine.drop", Set.of(PRIVILEGE_COMPUTE_ENGINE_USAGE)),
    PRIVILEGE_JOB_CREATE(UUID.fromString("587b9995-79d7-4e54-8bad-4b56471c8cf4"), SecurableType.SECURABLE_TYPE_COMPUTE_ENGINE, "job.create", Set.of(PRIVILEGE_COMPUTE_ENGINE_USAGE)),
    PRIVILEGE_JOB_USAGE(UUID.fromString("76199ed7-30a6-4eda-82e7-8ab01ab74b88"), SecurableType.SECURABLE_TYPE_JOB, "job.usage", Set.of()),
    PRIVILEGE_JOB_ALTER(UUID.fromString("d77a3d45-6246-4837-8e61-a6f3ad22dd73"), SecurableType.SECURABLE_TYPE_JOB, "job.alter", Set.of(PRIVILEGE_JOB_USAGE)),
    PRIVILEGE_JOB_DROP(UUID.fromString("c30d3d76-42e1-4c1c-aa4b-ac8629768af2"), SecurableType.SECURABLE_TYPE_JOB, "job.drop", Set.of(PRIVILEGE_JOB_USAGE)),
    PRIVILEGE_SECURITY_PROVIDER_CREATE(UUID.fromString("e515bff3-843d-46fc-b35f-c45d91045a89"), SecurableType.SECURABLE_TYPE_METASTORE, "security-provider.create", Set.of()),
    PRIVILEGE_SECURITY_PROVIDER_USAGE(UUID.fromString("f2c79528-c4cd-4a9b-a9e5-1c306058a7a4"), SecurableType.SECURABLE_TYPE_SECURITY_PROVIDER, "security-provider.usage", Set.of()),
    PRIVILEGE_SECURITY_PROVIDER_ALTER(UUID.fromString("741d2ba8-a4a9-44f1-bc0e-19a82f654810"), SecurableType.SECURABLE_TYPE_SECURITY_PROVIDER, "security-provider.alter", Set.of(PRIVILEGE_SECURITY_PROVIDER_USAGE)),
    PRIVILEGE_SECURITY_PROVIDER_DROP(UUID.fromString("f86fc569-1421-4d20-9e5a-ebd6b0ea512a"), SecurableType.SECURABLE_TYPE_SECURITY_PROVIDER, "security-provider.drop", Set.of(PRIVILEGE_SECURITY_PROVIDER_USAGE));

    private static final Map<UUID, CatalogPrivilege> ID_TO_TYPE;
    private static final Map<String, CatalogPrivilege> CAPTION_TO_TYPE;
    private static final Map<SecurableType, Set<CatalogPrivilege>> APPLICABLE_PRIVILEGES;
    private static final Map<CatalogPrivilege, Set<CatalogPrivilege>> REVERSE_IMPLIED_PRIVILEGES;
    private final UUID id;
    private final SecurableType securableType;
    private final String caption;
    private final Set<CatalogPrivilege> impliedPrivileges;

    private CatalogPrivilege(UUID id, SecurableType securableType, String caption, Set<CatalogPrivilege> impliedPrivileges) {
        this.id = id;
        this.securableType = securableType;
        this.caption = caption;
        Verify.verify((impliedPrivileges.isEmpty() || impliedPrivileges.stream().allMatch(p -> securableType.equals((Object)p.securableType)) ? 1 : 0) != 0, (String)("Implied privileges for " + String.valueOf((Object)this) + " reference other securable types"), (Object[])new Object[0]);
        this.impliedPrivileges = impliedPrivileges;
    }

    public UUID id() {
        return this.id;
    }

    public SecurableType securableType() {
        return this.securableType;
    }

    public String caption() {
        return this.caption;
    }

    public Set<CatalogPrivilege> getImpliedPrivileges() {
        return this.impliedPrivileges;
    }

    public static Set<CatalogPrivilege> collectEffectivePrivileges(Set<CatalogPrivilege> privileges) {
        if (privileges.isEmpty()) {
            return Set.of();
        }
        HashSet<CatalogPrivilege> res = new HashSet<CatalogPrivilege>();
        SecurableType expectedSecurableType = privileges.iterator().next().securableType();
        for (CatalogPrivilege privilege : privileges) {
            CatalogPrivilege.collectEffectivePrivileges(privilege, expectedSecurableType, res);
        }
        return res;
    }

    private static void collectEffectivePrivileges(CatalogPrivilege privilege, SecurableType expectedSecurableType, Set<CatalogPrivilege> res) {
        Verify.verify((boolean)privilege.securableType().equals((Object)expectedSecurableType), (String)String.format("Privilege %s has securable type %s, but %s expected", new Object[]{privilege, expectedSecurableType, privilege.securableType()}), (Object[])new Object[0]);
        if (!res.add(privilege)) {
            return;
        }
        for (CatalogPrivilege additionalPrivilege : REVERSE_IMPLIED_PRIVILEGES.getOrDefault((Object)privilege, Set.of())) {
            CatalogPrivilege.collectEffectivePrivileges(additionalPrivilege, expectedSecurableType, res);
        }
    }

    public static CatalogPrivilege resolveByOrdinal(int ordinal) {
        for (CatalogPrivilege privilege : CatalogPrivilege.values()) {
            if (privilege.ordinal() != ordinal) continue;
            return privilege;
        }
        throw new IllegalArgumentException("Cannot resolve privilege ordinal: " + ordinal);
    }

    public static CatalogPrivilege resolveById(UUID privilegeId) {
        CatalogPrivilege type = ID_TO_TYPE.get(privilegeId);
        if (type == null) {
            throw new CatalogInternalServerErrorException("Unknown privilege ID: " + String.valueOf(privilegeId));
        }
        return type;
    }

    @VisibleForTesting
    public static CatalogPrivilege resolveByCaption(String caption) {
        if (caption != null) {
            caption = caption.trim().toLowerCase(Locale.ROOT);
        }
        if (caption == null || caption.isEmpty()) {
            throw new CatalogBadRequestException("Privilege cannot be empty");
        }
        CatalogPrivilege action = CAPTION_TO_TYPE.get(caption);
        if (action == null) {
            throw new CatalogBadRequestException("Unknown privilege: " + caption);
        }
        return action;
    }

    public static CatalogPrivilege resolveForSecurable(SecurableType securableType, String caption) {
        if (caption != null) {
            caption = caption.trim();
        }
        if (caption == null || caption.isEmpty()) {
            throw new CatalogBadRequestException("Privilege cannot be empty");
        }
        CatalogPrivilege privilege = CAPTION_TO_TYPE.get(caption);
        if (privilege != null) {
            SecurableType privilegeSecurableType = privilege.securableType;
            while (true) {
                if (securableType.equals((Object)privilegeSecurableType)) {
                    return privilege;
                }
                if (privilegeSecurableType.parent().isEmpty()) break;
                privilegeSecurableType = privilegeSecurableType.parent().get();
            }
        }
        throw new CatalogBadRequestException(String.format("Unsupported privilege \"%s\" for securable type \"%s\". Allowed values: %s", caption, securableType.caption(), CatalogPrivilege.applicablePrivileges(securableType).stream().map(CatalogPrivilege::caption).sorted().toList()));
    }

    @VisibleForTesting
    public static Set<CatalogPrivilege> applicablePrivileges(SecurableType securableType) {
        return APPLICABLE_PRIVILEGES.get((Object)securableType);
    }

    static {
        ImmutableMap.Builder idToTypeBuilder = ImmutableMap.builder();
        for (CatalogPrivilege privilege : CatalogPrivilege.values()) {
            idToTypeBuilder.put((Object)privilege.id(), (Object)privilege);
        }
        ID_TO_TYPE = idToTypeBuilder.buildOrThrow();
        ImmutableMap.Builder captionToTypeBuilder = ImmutableMap.builder();
        for (CatalogPrivilege privilege : CatalogPrivilege.values()) {
            captionToTypeBuilder.put((Object)privilege.caption(), (Object)privilege);
        }
        CAPTION_TO_TYPE = captionToTypeBuilder.buildOrThrow();
        HashMap<SecurableType, Set<CatalogPrivilege>> applicablePrivileges = new HashMap<SecurableType, Set<CatalogPrivilege>>();
        block2: for (CatalogPrivilege privilege : CatalogPrivilege.values()) {
            SecurableType currentSecurableType = privilege.securableType();
            while (true) {
                applicablePrivileges.computeIfAbsent(currentSecurableType, key -> new HashSet()).add(privilege);
                if (currentSecurableType.parent().isEmpty()) continue block2;
                currentSecurableType = currentSecurableType.parent().get();
            }
        }
        APPLICABLE_PRIVILEGES = applicablePrivileges;
        HashMap reverseImpliedPrivileges = new HashMap();
        for (CatalogPrivilege privilege : CatalogPrivilege.values()) {
            privilege.impliedPrivileges.forEach(impliedPrivilege -> reverseImpliedPrivileges.computeIfAbsent(impliedPrivilege, ignore -> new HashSet()).add(privilege));
        }
        REVERSE_IMPLIED_PRIVILEGES = ImmutableMap.copyOf(reverseImpliedPrivileges);
    }
}

