/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.security.audit;

import com.google.common.collect.ImmutableList;
import java.util.List;
import ru.cedrusdata.catalog.core.security.audit.AuditListener;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationCheckResult;

public class AuditManager {
    private volatile List<AuditListener> listeners = List.of();

    public synchronized void registerListener(AuditListener listener) {
        this.listeners = ImmutableList.builder().addAll(this.listeners).add((Object)listener).build();
    }

    public synchronized void unregisterListener(AuditListener listener) {
        this.listeners = ImmutableList.builder().addAll(this.listeners.stream().filter(element -> element != listener).toList()).build();
    }

    public void logAuthorizationEvent(AuthorizationCheckResult event) {
        List<AuditListener> currentListeners = this.listeners;
        if (currentListeners.isEmpty()) {
            return;
        }
        for (AuditListener listener : currentListeners) {
            listener.onAuthorization(event);
        }
    }
}

