/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.principal;

import java.util.Optional;

public enum PrincipalType {
    USER("user", 0),
    ROLE("role", 1);

    private final String caption;
    private final short value;

    private PrincipalType(String caption, short value) {
        this.caption = caption;
        this.value = value;
    }

    public String getCaption() {
        return this.caption;
    }

    public short getValue() {
        return this.value;
    }

    public static PrincipalType resolveFromShort(short value) {
        for (PrincipalType type : PrincipalType.values()) {
            if (type.getValue() != value) continue;
            return type;
        }
        throw new IllegalArgumentException("Unsupported principal type: " + value);
    }

    public static Optional<PrincipalType> resolveFromString(String caption) {
        for (PrincipalType type : PrincipalType.values()) {
            if (!type.getCaption().equalsIgnoreCase(caption)) continue;
            return Optional.of(type);
        }
        return Optional.empty();
    }
}

