/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.maintenance;

import io.airlift.concurrent.BoundedExecutor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import ru.cedrusdata.catalog.core.maintenance.MaintenanceOperationObject;

class MaintenanceOperationExecutor
implements AutoCloseable {
    private final ObjectQueues objectQueues = new ObjectQueues();
    private final BoundedExecutor executor;
    private final int maxOperations;
    private final ExecutorService threadPool;

    MaintenanceOperationExecutor(int maxOperations, ThreadFactory threadFactory) {
        this.maxOperations = maxOperations;
        this.threadPool = Executors.newCachedThreadPool(threadFactory);
        this.executor = new BoundedExecutor((Executor)this.threadPool, maxOperations);
    }

    int getMaxOperations() {
        return this.maxOperations;
    }

    void execute(Operation operation) {
        this.executor.execute((Runnable)new OperationRunner(operation));
    }

    @Override
    public void close() {
        this.threadPool.close();
    }

    private static class ObjectQueues {
        private final Map<UUID, Queue<Runnable>> queueMap = new HashMap<UUID, Queue<Runnable>>();

        private ObjectQueues() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void submitOrRun(UUID objectId, Runnable runnable, Executor executor, int maxOperations) {
            int runningOperationsNum;
            Map<UUID, Queue<Runnable>> map = this.queueMap;
            synchronized (map) {
                Queue<Runnable> queue = this.queueMap.get(objectId);
                if (queue != null) {
                    queue.add(runnable);
                    return;
                }
                this.queueMap.put(objectId, new LinkedList());
                runningOperationsNum = this.queueMap.size();
            }
            if (runningOperationsNum < maxOperations) {
                executor.execute(runnable);
            } else {
                runnable.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Runnable operationCompleted(UUID objectId) {
            Map<UUID, Queue<Runnable>> map = this.queueMap;
            synchronized (map) {
                Queue<Runnable> queue = this.queueMap.get(objectId);
                if (queue.isEmpty()) {
                    this.queueMap.remove(objectId);
                    return null;
                }
                return queue.poll();
            }
        }
    }

    private class OperationRunner
    implements Runnable {
        private final Operation operation;
        private int remainingOperations;
        private boolean allOperationsSubmitted;
        private volatile Throwable error;

        OperationRunner(Operation operation) {
            this.operation = operation;
        }

        @Override
        public void run() {
            Iterator<MaintenanceOperationObject> objectIterator = this.operation.objectIterator();
            try {
                while (!this.operation.future().isDone() && objectIterator.hasNext()) {
                    MaintenanceOperationObject nextObject = objectIterator.next();
                    this.processNextObject(nextObject);
                }
            }
            catch (Throwable e) {
                this.error = e;
            }
            finally {
                this.checkComplete(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processNextObject(MaintenanceOperationObject object) {
            Runnable runnable = () -> {
                try {
                    this.runForObject(object);
                }
                finally {
                    Runnable next = MaintenanceOperationExecutor.this.objectQueues.operationCompleted(object.objectId());
                    if (next != null) {
                        MaintenanceOperationExecutor.this.executor.execute(next);
                    }
                }
            };
            OperationRunner operationRunner = this;
            synchronized (operationRunner) {
                ++this.remainingOperations;
            }
            MaintenanceOperationExecutor.this.objectQueues.submitOrRun(object.objectId(), runnable, (Executor)MaintenanceOperationExecutor.this.executor, MaintenanceOperationExecutor.this.maxOperations);
        }

        private void runForObject(MaintenanceOperationObject object) {
            try {
                if (!this.operation.future().isDone()) {
                    this.operation.run(object);
                }
            }
            finally {
                this.checkComplete(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkComplete(boolean allSubmitted) {
            boolean complete;
            OperationRunner operationRunner = this;
            synchronized (operationRunner) {
                if (allSubmitted) {
                    this.allOperationsSubmitted = true;
                } else {
                    --this.remainingOperations;
                }
                complete = this.remainingOperations == 0 && this.allOperationsSubmitted;
            }
            if (complete) {
                this.operation.complete(this.error);
            }
        }
    }

    static interface Operation {
        public Iterator<MaintenanceOperationObject> objectIterator();

        public void run(MaintenanceOperationObject var1);

        public void complete(Throwable var1);

        public Future<?> future();
    }
}

