/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.i18n;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import ru.cedrusdata.catalog.plugin.CatalogPluginRegistry;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngineType;
import ru.cedrusdata.catalog.spi.model.LabelListResponse;
import ru.cedrusdata.catalog.spi.model.LocaleInfo;
import ru.cedrusdata.catalog.spi.model.LocaleListResponse;

public class InternationalizationService {
    private final CatalogPluginRegistry pluginRegistry;

    @Inject
    public InternationalizationService(CatalogPluginRegistry pluginRegistry) {
        this.pluginRegistry = pluginRegistry;
    }

    public LabelListResponse getLabels(Locale locale) {
        ImmutableMap.Builder labels = ImmutableMap.builder();
        for (CatalogComputeEngineType engineType : CatalogComputeEngineType.values()) {
            this.pluginRegistry.getCatalogComputeEngineProvider(engineType).ifPresent(provider -> {
                ResourceBundle bundle = (ResourceBundle)provider.labels().get(locale);
                if (bundle != null) {
                    Enumeration<String> keys = bundle.getKeys();
                    while (keys.hasMoreElements()) {
                        String key = keys.nextElement();
                        labels.put((Object)key, (Object)bundle.getString(key));
                    }
                }
            });
        }
        return new LabelListResponse((Map)labels.buildOrThrow());
    }

    public LocaleListResponse getLocales() {
        HashSet locales = new HashSet();
        for (CatalogComputeEngineType engineType : CatalogComputeEngineType.values()) {
            this.pluginRegistry.getCatalogComputeEngineProvider(engineType).ifPresent(provider -> locales.addAll(provider.labels().keySet()));
        }
        return new LocaleListResponse(locales.stream().map(this::toLocaleInfo).toList());
    }

    private LocaleInfo toLocaleInfo(Locale locale) {
        String displayName = locale.getDisplayName(locale);
        return new LocaleInfo(locale.getLanguage(), Character.toUpperCase(displayName.charAt(0)) + displayName.substring(1));
    }
}

