/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.computeengine.local;

import com.google.common.base.Verify;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.Table;
import ru.cedrusdata.catalog.CurrentTimeSupplier;
import ru.cedrusdata.catalog.core.computeengine.local.LocalRemoveOrphanFilesOperation;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngineOperation;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngineOperationFactory;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngineOperationObjectType;
import ru.cedrusdata.catalog.spi.computeengine.CatalogTable;
import ru.cedrusdata.catalog.spi.computeengine.result.Accumulator;
import ru.cedrusdata.catalog.spi.computeengine.result.CompositeComputeEngineResultAggregator;
import ru.cedrusdata.catalog.spi.computeengine.result.ComputeEngineResultAggregator;
import ru.cedrusdata.catalog.spi.computeengine.result.LongAccumulator;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystem;

public class LocalRemoveOrphanFilesOperationFactory
implements CatalogComputeEngineOperationFactory {
    private final CurrentTimeSupplier currentTimeSupplier;
    private final int olderThan;

    public LocalRemoveOrphanFilesOperationFactory(CurrentTimeSupplier currentTimeSupplier, Map<String, String> params) {
        CatalogComputeEngineOperationFactory.validateNoExtraParameters((String)"remove-orphan-files", params, Set.of("older-than"));
        this.currentTimeSupplier = currentTimeSupplier;
        this.olderThan = CatalogComputeEngineOperationFactory.parsePositiveIntegerParameter(params, (String)"older-than", (int)3);
    }

    public String name() {
        return "remove-orphan-files";
    }

    public Set<CatalogComputeEngineOperationObjectType> supportedObjectTypes() {
        return Set.of(CatalogComputeEngineOperationObjectType.ICEBERG_TABLE, CatalogComputeEngineOperationObjectType.ICEBERG_CEDRUSDATA_MATERIALIZED_VIEW);
    }

    public boolean loadTable() {
        return true;
    }

    public CatalogComputeEngineOperation createTableOperation(CatalogTable table) {
        Verify.verify((boolean)table.fileSystem().isPresent());
        Verify.verify((boolean)table.table().isPresent());
        Instant removeOlderThan = Instant.ofEpochMilli(this.currentTimeSupplier.currentTimeMillis() - TimeUnit.DAYS.toMillis(this.olderThan));
        return new LocalRemoveOrphanFilesOperation((CatalogFileSystem)table.fileSystem().get(), (Table)table.table().get(), removeOlderThan);
    }

    public ComputeEngineResultAggregator createResultAggregator() {
        return CompositeComputeEngineResultAggregator.newBuilder().add("deleted-files", (Accumulator)new LongAccumulator()).build();
    }
}

