/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.computeengine.local;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import ru.cedrusdata.catalog.core.computeengine.local.BatchDelete;
import ru.cedrusdata.catalog.iceberg.table.CatalogTableOperations;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngineOperation;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngineOperationContext;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystem;

public class LocalExpireSnapshotsOperation
implements CatalogComputeEngineOperation {
    private final CatalogFileSystem fileSystem;
    private final Table table;
    private final Instant expireOlderThan;
    private final int retainLastSnapshotsNum;

    public LocalExpireSnapshotsOperation(CatalogFileSystem fileSystem, Table table, Instant expireOlderThan, int retainLastSnapshotsNum) {
        this.fileSystem = fileSystem;
        this.table = table;
        this.expireOlderThan = expireOlderThan;
        this.retainLastSnapshotsNum = retainLastSnapshotsNum;
    }

    public Map<String, String> execute(CatalogComputeEngineOperationContext operationContext) {
        BatchDelete batchDelete = new BatchDelete(this.fileSystem, false);
        TableOperations operations = ((HasTableOperations)this.table).operations();
        TableMetadata baseMetadata = operations.current();
        this.table.expireSnapshots().deleteWith((Consumer)batchDelete).cleanExpiredFiles(true).retainLast(this.retainLastSnapshotsNum).expireOlderThan(this.expireOlderThan.toEpochMilli()).commit();
        int deletedFilesCount = batchDelete.finish();
        if (batchDelete.deleteError() != null) {
            throw batchDelete.deleteError();
        }
        Optional<Integer> expiredSnapshotsCount = Optional.of(0);
        if (deletedFilesCount > 0 && operations instanceof CatalogTableOperations) {
            TableMetadata newMetadata = ((CatalogTableOperations)operations).lastCommittedMetadata();
            Verify.verifyNotNull((Object)newMetadata);
            expiredSnapshotsCount = Optional.of(baseMetadata.snapshots().size() - newMetadata.snapshots().size());
        }
        ImmutableMap.Builder result = ImmutableMap.builder();
        result.put((Object)"deleted-files", (Object)Integer.toString(deletedFilesCount));
        result.put((Object)"expired-snapshots", (Object)Integer.toString(expiredSnapshotsCount.orElse(0)));
        return result.buildOrThrow();
    }
}

