/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.computeengine.local;

import com.google.inject.Inject;
import java.util.Map;
import ru.cedrusdata.catalog.CurrentTimeSupplier;
import ru.cedrusdata.catalog.core.computeengine.local.LocalExpireSnapshotsOperationFactory;
import ru.cedrusdata.catalog.core.computeengine.local.LocalRemoveOrphanFilesOperationFactory;
import ru.cedrusdata.catalog.server.ServerVersion;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngine;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngineOperationFactory;
import ru.cedrusdata.catalog.spi.exception.CatalogBadRequestException;

public class LocalComputeEngine
implements CatalogComputeEngine {
    private final ServerVersion serverVersion;
    private final CurrentTimeSupplier timeSupplier;

    @Inject
    public LocalComputeEngine(ServerVersion serverVersion, CurrentTimeSupplier timeSupplier) {
        this.serverVersion = serverVersion;
        this.timeSupplier = timeSupplier;
    }

    public CatalogComputeEngineOperationFactory createOperationFactory(String operationName, Map<String, String> operationParameters) {
        if ("expire-snapshots".equalsIgnoreCase(operationName)) {
            return new LocalExpireSnapshotsOperationFactory(this.timeSupplier, operationParameters);
        }
        if ("remove-orphan-files".equalsIgnoreCase(operationName)) {
            return new LocalRemoveOrphanFilesOperationFactory(this.timeSupplier, operationParameters);
        }
        throw new CatalogBadRequestException(String.format("Unsupported operation: \"%s\". Supported operations: %s and %s", operationName, "remove-orphan-files", "expire-snapshots"));
    }

    public Map<String, String> check() {
        return Map.of("catalog-version", this.serverVersion.getVersion());
    }

    public void close() {
    }
}

