/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core;

import java.util.concurrent.atomic.AtomicBoolean;
import ru.cedrusdata.catalog.core.AbstractUsageAwareResource;

public class UsageAwareResourceSession<T extends AutoCloseable>
implements AutoCloseable {
    protected final AbstractUsageAwareResource<T> usageAwareResource;
    private final AtomicBoolean closed = new AtomicBoolean();

    public UsageAwareResourceSession(AbstractUsageAwareResource<T> usageAwareResource) {
        this.usageAwareResource = usageAwareResource;
        usageAwareResource.acquire();
    }

    public T resource() {
        return this.usageAwareResource.resource();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.usageAwareResource.release();
        }
    }
}

