/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.view.ImmutableViewMetadata;
import org.apache.iceberg.view.ViewHistoryEntry;
import org.apache.iceberg.view.ViewMetadata;
import org.apache.iceberg.view.ViewVersion;

public class ViewMetadataUtils {
    private ViewMetadataUtils() {
    }

    public static ViewMetadata adjustToVersion(ViewMetadata viewMetadata, int currentVersionId) {
        ViewVersion currentVersion = viewMetadata.version(currentVersionId);
        Verify.verify((currentVersion != null ? 1 : 0) != 0);
        long maxTimestampMillis = currentVersion.timestampMillis();
        ArrayList<ViewVersion> versions = new ArrayList<ViewVersion>();
        HashSet<Integer> requiredVersionIds = new HashSet<Integer>();
        for (ViewVersion version : viewMetadata.versions()) {
            if (version.timestampMillis() > maxTimestampMillis) continue;
            versions.add(version);
            requiredVersionIds.add(version.versionId());
        }
        List<ViewHistoryEntry> filteredHistory = viewMetadata.history().stream().filter(entry -> requiredVersionIds.contains(entry.versionId())).toList();
        return ImmutableViewMetadata.of((String)viewMetadata.uuid(), (int)viewMetadata.formatVersion(), (String)viewMetadata.location(), (List)viewMetadata.schemas(), (int)currentVersionId, versions, filteredHistory, (Map)viewMetadata.properties(), List.of(), (String)viewMetadata.metadataFileLocation());
    }
}

