/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionStatisticsFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.SortField;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.TableMetadata;

public class TableMetadataUtils {
    private TableMetadataUtils() {
    }

    public static TableMetadata adjustToSnapshot(TableMetadata tableMetadata, long currentSnapshotId) {
        Snapshot currentSnapshot = tableMetadata.snapshot(currentSnapshotId);
        Verify.verify((currentSnapshot != null ? 1 : 0) != 0);
        long maxTimestampMillis = currentSnapshot.timestampMillis();
        ArrayList<Snapshot> snapshots = new ArrayList<Snapshot>();
        HashSet<Long> requiredSnapshotIds = new HashSet<Long>();
        for (Snapshot snapshot : tableMetadata.snapshots()) {
            if (snapshot.timestampMillis() > maxTimestampMillis) continue;
            snapshots.add(snapshot);
            requiredSnapshotIds.add(snapshot.snapshotId());
        }
        List<HistoryEntry> filteredSnapshotLog = tableMetadata.snapshotLog().stream().filter(entry -> requiredSnapshotIds.contains(entry.snapshotId())).toList();
        Map<String, SnapshotRef> filteredRefs = tableMetadata.refs().entrySet().stream().filter(entry -> requiredSnapshotIds.contains(((SnapshotRef)entry.getValue()).snapshotId())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        List<StatisticsFile> filteredStatisticsFiles = tableMetadata.statisticsFiles().stream().filter(entry -> requiredSnapshotIds.contains(entry.snapshotId())).toList();
        List<PartitionStatisticsFile> filteredPartitionStatisticsFiles = tableMetadata.partitionStatisticsFiles().stream().filter(entry -> requiredSnapshotIds.contains(entry.snapshotId())).toList();
        Schema currentSchema = (Schema)tableMetadata.schemasById().get(currentSnapshot.schemaId());
        List<PartitionSpec> updatedSpecs = tableMetadata.specs().stream().map(entry -> TableMetadataUtils.updateSpecSchema(currentSchema, entry)).toList();
        List<SortOrder> updatedSortOrders = tableMetadata.sortOrders().stream().map(entry -> TableMetadataUtils.updateSortOrderSchema(currentSchema, entry)).toList();
        return new TableMetadata(tableMetadata.metadataFileLocation(), tableMetadata.formatVersion(), tableMetadata.uuid(), tableMetadata.location(), tableMetadata.lastSequenceNumber(), tableMetadata.lastUpdatedMillis(), tableMetadata.lastColumnId(), currentSnapshot.schemaId().intValue(), tableMetadata.schemas(), tableMetadata.defaultSpecId(), updatedSpecs, tableMetadata.lastAssignedPartitionId(), tableMetadata.defaultSortOrderId(), updatedSortOrders, tableMetadata.properties(), currentSnapshotId, snapshots, null, filteredSnapshotLog, tableMetadata.previousFiles(), filteredRefs, filteredStatisticsFiles, filteredPartitionStatisticsFiles, List.of());
    }

    private static PartitionSpec updateSpecSchema(Schema schema, PartitionSpec partitionSpec) {
        PartitionSpec.Builder specBuilder = PartitionSpec.builderFor((Schema)schema).withSpecId(partitionSpec.specId());
        for (PartitionField field : partitionSpec.fields()) {
            specBuilder.add(field.sourceId(), field.fieldId(), field.name(), field.transform());
        }
        return specBuilder.buildUnchecked();
    }

    private static SortOrder updateSortOrderSchema(Schema schema, SortOrder sortOrder) {
        SortOrder.Builder builder = SortOrder.builderFor((Schema)schema).withOrderId(sortOrder.orderId());
        for (SortField field : sortOrder.fields()) {
            builder.addSortField(field.transform(), field.sourceId(), field.direction(), field.nullOrder());
        }
        return builder.buildUnchecked();
    }
}

