/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.filesystem.common;

import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.spi.security.ConnectorIdentity;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import ru.cedrusdata.catalog.filesystem.common.CatalogTrinoFileSystem;
import ru.cedrusdata.catalog.spi.exception.CatalogBadRequestException;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystem;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystemFactory;

public abstract class CatalogTrinoFileSystemFactory
implements CatalogFileSystemFactory {
    protected final TrinoFileSystemFactory delegate;

    protected CatalogTrinoFileSystemFactory(TrinoFileSystemFactory delegate) {
        this.delegate = delegate;
    }

    public CatalogFileSystem create(String user, Map<String, String> additionalProperties) {
        if (!additionalProperties.isEmpty()) {
            throw new CatalogBadRequestException("Unsupported additional file system properties: " + String.valueOf(additionalProperties.keySet()));
        }
        return new CatalogTrinoFileSystem(this.delegate.create(ConnectorIdentity.ofUser((String)user)), Optional.empty());
    }

    public final Optional<String> isLocationValid(String location) {
        URI locationUri;
        try {
            locationUri = new URI(location);
        }
        catch (URISyntaxException e) {
            return Optional.of(String.format("Cannot parse file system location \"%s\": %s", location, e.getMessage()));
        }
        return this.isLocationValid(locationUri);
    }

    protected abstract Optional<String> isLocationValid(URI var1);
}

