/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.filesystem.common;

import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import ru.cedrusdata.catalog.filesystem.common.CatalogTrinoFileIterator;
import ru.cedrusdata.catalog.filesystem.common.CatalogTrinoFileSystemInputFile;
import ru.cedrusdata.catalog.filesystem.common.CatalogTrinoFileSystemOutputFile;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileIterator;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystem;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystemInputFile;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystemOutputFile;

public class CatalogTrinoFileSystem
implements CatalogFileSystem {
    private final TrinoFileSystem delegate;
    private final Optional<CloseCallback> closeable;

    public CatalogTrinoFileSystem(TrinoFileSystem delegate, Optional<CloseCallback> closeable) {
        this.delegate = delegate;
        this.closeable = closeable;
    }

    public CatalogFileSystemInputFile newInputFile(String location) {
        return new CatalogTrinoFileSystemInputFile(this.delegate.newInputFile(Location.of((String)location)));
    }

    public CatalogFileSystemInputFile newInputFile(String location, long length) {
        return new CatalogTrinoFileSystemInputFile(this.delegate.newInputFile(Location.of((String)location), length));
    }

    public CatalogFileSystemOutputFile newOutputFile(String location) {
        return new CatalogTrinoFileSystemOutputFile(this.delegate.newOutputFile(Location.of((String)location)));
    }

    public void deleteFile(String location) throws IOException {
        this.delegate.deleteFile(Location.of((String)location));
    }

    public void deleteFiles(Collection<String> locations) throws IOException {
        this.delegate.deleteFiles(locations.stream().map(Location::of).toList());
    }

    public void deleteDirectory(String location) throws IOException {
        this.delegate.deleteDirectory(Location.of((String)location));
    }

    public CatalogFileIterator listFiles(String location) throws IOException {
        return new CatalogTrinoFileIterator(this.delegate.listFiles(Location.of((String)location)));
    }

    public Optional<Boolean> directoryExists(String location) throws IOException {
        return this.delegate.directoryExists(Location.of((String)location));
    }

    public void close() {
        if (this.closeable.isPresent()) {
            this.closeable.get().run();
        }
    }

    @FunctionalInterface
    public static interface CloseCallback {
        public void run();
    }
}

