/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.info;

import org.openjdk.jol.vm.VM;

public abstract class GraphPathRecord {
    protected final GraphPathRecord parent;
    private final int depth;
    private final Object obj;
    private long size;

    GraphPathRecord(GraphPathRecord parent, int depth, Object obj) {
        this.parent = parent;
        this.obj = obj;
        this.depth = depth;
    }

    final Object obj() {
        return this.obj;
    }

    public abstract String path();

    public final Class<?> klass() {
        return this.obj.getClass();
    }

    public final long size() {
        if (this.size == 0L) {
            this.size = VM.current().sizeOf(this.obj);
        }
        return this.size;
    }

    final void setSize(long size) {
        this.size = size;
    }

    final int depth() {
        return this.depth;
    }
}

