/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.security;

import io.trino.spi.security.SelectedRole;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ConnectorIdentity {
    private final String user;
    private final Set<String> groups;
    private final Optional<Principal> principal;
    private final Set<String> enabledSystemRoles;
    private final Optional<SelectedRole> connectorRole;
    private final Map<String, String> extraCredentials;

    @Deprecated
    public ConnectorIdentity(String user, Optional<Principal> principal, Optional<SelectedRole> connectorRole) {
        this(user, principal, connectorRole, Collections.emptyMap());
    }

    @Deprecated
    public ConnectorIdentity(String user, Optional<Principal> principal, Optional<SelectedRole> connectorRole, Map<String, String> extraCredentials) {
        this(user, Collections.emptySet(), principal, Collections.emptySet(), connectorRole, extraCredentials);
    }

    private ConnectorIdentity(String user, Set<String> groups, Optional<Principal> principal, Set<String> enabledSystemRoles, Optional<SelectedRole> connectorRole, Map<String, String> extraCredentials) {
        this.user = Objects.requireNonNull(user, "user is null");
        this.groups = Set.copyOf((Collection)Objects.requireNonNull(groups, "groups is null"));
        this.principal = Objects.requireNonNull(principal, "principal is null");
        this.enabledSystemRoles = Set.copyOf((Collection)Objects.requireNonNull(enabledSystemRoles, "enabledSystemRoles is null"));
        this.connectorRole = Objects.requireNonNull(connectorRole, "connectorRole is null");
        this.extraCredentials = Map.copyOf(Objects.requireNonNull(extraCredentials, "extraCredentials is null"));
    }

    public String getUser() {
        return this.user;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public Optional<Principal> getPrincipal() {
        return this.principal;
    }

    public Set<String> getEnabledSystemRoles() {
        return this.enabledSystemRoles;
    }

    @Deprecated
    public Optional<SelectedRole> getRole() {
        return this.getConnectorRole();
    }

    public Optional<SelectedRole> getConnectorRole() {
        return this.connectorRole;
    }

    public Map<String, String> getExtraCredentials() {
        return this.extraCredentials;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ConnectorIdentity{");
        sb.append("user='").append(this.user).append('\'');
        sb.append(", groups=").append(this.groups);
        this.principal.ifPresent(principal -> sb.append(", principal=").append(principal));
        sb.append(", enabledSystemroles=").append(this.enabledSystemRoles);
        this.connectorRole.ifPresent(role -> sb.append(", connectorRole=").append(role));
        sb.append(", extraCredentials=").append(this.extraCredentials.keySet());
        sb.append('}');
        return sb.toString();
    }

    public static ConnectorIdentity ofUser(String user) {
        return new Builder(user).build();
    }

    public static Builder forUser(String user) {
        return new Builder(user);
    }

    public static class Builder {
        private final String user;
        private Set<String> groups = Collections.emptySet();
        private Optional<Principal> principal = Optional.empty();
        private Set<String> enabledSystemRoles = new HashSet<String>();
        private Optional<SelectedRole> connectorRole = Optional.empty();
        private Map<String, String> extraCredentials = new HashMap<String, String>();

        private Builder(String user) {
            this.user = Objects.requireNonNull(user, "user is null");
        }

        public Builder withGroups(Set<String> groups) {
            this.groups = Set.copyOf((Collection)Objects.requireNonNull(groups, "groups is null"));
            return this;
        }

        public Builder withPrincipal(Principal principal) {
            return this.withPrincipal(Optional.of(Objects.requireNonNull(principal, "principal is null")));
        }

        public Builder withPrincipal(Optional<Principal> principal) {
            this.principal = Objects.requireNonNull(principal, "principal is null");
            return this;
        }

        public Builder withEnabledSystemRoles(Set<String> enabledSystemRoles) {
            this.enabledSystemRoles = new HashSet<String>((Collection)Objects.requireNonNull(enabledSystemRoles, "enabledSystemRoles is null"));
            return this;
        }

        @Deprecated
        public Builder withRole(SelectedRole role) {
            return this.withConnectorRole(role);
        }

        @Deprecated
        public Builder withRole(Optional<SelectedRole> role) {
            return this.withConnectorRole(role);
        }

        public Builder withConnectorRole(SelectedRole connectorRole) {
            return this.withConnectorRole(Optional.of(Objects.requireNonNull(connectorRole, "connectorRole is null")));
        }

        public Builder withConnectorRole(Optional<SelectedRole> connectorRole) {
            this.connectorRole = Objects.requireNonNull(connectorRole, "connectorRole is null");
            return this;
        }

        public Builder withExtraCredentials(Map<String, String> extraCredentials) {
            this.extraCredentials = new HashMap<String, String>(Objects.requireNonNull(extraCredentials, "extraCredentials is null"));
            return this;
        }

        public ConnectorIdentity build() {
            return new ConnectorIdentity(this.user, this.groups, this.principal, this.enabledSystemRoles, this.connectorRole, this.extraCredentials);
        }
    }
}

