/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.securityprovider.ldap.client;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.net.ssl.SSLContext;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;
import ru.cedrusdata.catalog.securityprovider.ldap.CatalogLdapSecurityProviderConfig;
import ru.cedrusdata.catalog.securityprovider.ldap.client.CatalogLdapClient;
import ru.cedrusdata.catalog.securityprovider.ldap.client.CatalogLdapQuery;
import ru.cedrusdata.catalog.securityprovider.ldap.client.CatalogLdapSslSocketFactory;
import ru.cedrusdata.catalog.securityprovider.ldap.client.CatalogSslUtils;

public class CatalogJdkLdapClient
implements CatalogLdapClient {
    private static final Logger log = Logger.get(CatalogJdkLdapClient.class);
    private final Map<String, String> basicEnvironment;
    private final Optional<SSLContext> sslContext;

    @Inject
    public CatalogJdkLdapClient(CatalogLdapSecurityProviderConfig config) {
        String ldapUrl = Objects.requireNonNull(config.getLdapUrl(), "ldapUrl is null");
        if (ldapUrl.startsWith("ldap://")) {
            log.warn("Passwords will be sent in the clear to the LDAP server. Please consider using SSL to connect.");
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"java.naming.factory.initial", (Object)"com.sun.jndi.ldap.LdapCtxFactory").put((Object)"java.naming.provider.url", (Object)ldapUrl).put((Object)"java.naming.referral", (Object)(config.isIgnoreReferrals() ? "ignore" : "follow"));
        if (config.getLdapConnectionTimeout() > 0L) {
            builder.put((Object)"com.sun.jndi.ldap.connect.timeout", (Object)String.valueOf(config.getLdapConnectionTimeout()));
        }
        if (config.getLdapReadTimeout() > 0L) {
            builder.put((Object)"com.sun.jndi.ldap.read.timeout", (Object)String.valueOf(config.getLdapReadTimeout()));
        }
        this.basicEnvironment = builder.buildOrThrow();
        Optional<File> keystorePath = Optional.ofNullable(config.getKeystorePath()).map(File::new);
        Optional<File> truststorePath = Optional.ofNullable(config.getTrustStorePath()).map(File::new);
        this.sslContext = CatalogJdkLdapClient.createSslContext(keystorePath, Optional.ofNullable(config.getKeystorePassword()), truststorePath, Optional.ofNullable(config.getTruststorePassword()));
    }

    @Override
    public <T> T processLdapContext(String userName, String password, CatalogLdapClient.LdapContextProcessor<T> contextProcessor) throws NamingException {
        try (CloseableContext context = this.createUserDirContext(userName, password);){
            T t = contextProcessor.process(context.context);
            return t;
        }
    }

    @Override
    public <T> T executeLdapQuery(String userName, String password, CatalogLdapQuery ldapQuery, CatalogLdapClient.LdapSearchResultProcessor<T> resultProcessor) throws NamingException {
        log.debug("Executing LDAP query: %s", new Object[]{ldapQuery.toString()});
        try (CloseableContext context = this.createUserDirContext(userName, password);){
            T t;
            block12: {
                CloseableSearchResults search = CatalogJdkLdapClient.searchContext(ldapQuery, context);
                try {
                    t = resultProcessor.process(search.searchResults);
                    if (search == null) break block12;
                }
                catch (Throwable throwable) {
                    if (search != null) {
                        try {
                            search.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                search.close();
            }
            return t;
        }
    }

    private static CloseableSearchResults searchContext(CatalogLdapQuery ldapQuery, CloseableContext context) throws NamingException {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setReturningAttributes(ldapQuery.getAttributes());
        NamingEnumeration<SearchResult> results = ldapQuery.getSearchFilterArguments() == null ? context.search(ldapQuery.getSearchBase(), ldapQuery.getSearchFilter(), searchControls) : context.search(ldapQuery.getSearchBase(), ldapQuery.getSearchFilter(), ldapQuery.getSearchFilterArguments(), searchControls);
        return new CloseableSearchResults(results);
    }

    private CloseableContext createUserDirContext(String userDistinguishedName, String password) throws NamingException {
        Map<String, String> environment = this.createEnvironment(userDistinguishedName, password);
        try {
            InitialDirContext context = new InitialDirContext(CatalogJdkLdapClient.createHashtable(environment));
            log.debug("Password validation successful for user DN [%s]", new Object[]{userDistinguishedName});
            return new CloseableContext(context);
        }
        catch (AuthenticationException e) {
            log.debug("Password validation failed for user DN [%s]: %s", new Object[]{userDistinguishedName, e.getMessage()});
            throw e;
        }
    }

    private Map<String, String> createEnvironment(String userDistinguishedName, String password) {
        ImmutableMap.Builder environment = ImmutableMap.builder().putAll(this.basicEnvironment).put((Object)"java.naming.security.authentication", (Object)"simple").put((Object)"java.naming.security.principal", (Object)userDistinguishedName).put((Object)"java.naming.security.credentials", (Object)password);
        this.sslContext.ifPresent(context -> {
            CatalogLdapSslSocketFactory.setSslContextForCurrentThread(context);
            environment.put((Object)"java.naming.ldap.factory.socket", (Object)CatalogLdapSslSocketFactory.class.getName());
        });
        return environment.buildOrThrow();
    }

    private static Optional<SSLContext> createSslContext(Optional<File> keyStorePath, Optional<String> keyStorePassword, Optional<File> trustStorePath, Optional<String> trustStorePassword) {
        if (keyStorePath.isEmpty() && trustStorePath.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(CatalogSslUtils.createSSLContext(keyStorePath, keyStorePassword, trustStorePath, trustStorePassword));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    @SuppressModernizer
    private static Hashtable<String, String> createHashtable(Map<String, String> map) {
        return new Hashtable<String, String>(map);
    }

    private record CloseableContext(DirContext context) implements AutoCloseable
    {
        public NamingEnumeration<SearchResult> search(String name, String filter, SearchControls searchControls) throws NamingException {
            return this.context.search(name, filter, searchControls);
        }

        public NamingEnumeration<SearchResult> search(String name, String filter, Object[] filterArguments, SearchControls searchControls) throws NamingException {
            return this.context.search(name, filter, filterArguments, searchControls);
        }

        @Override
        public void close() throws NamingException {
            this.context.close();
        }
    }

    private record CloseableSearchResults(NamingEnumeration<SearchResult> searchResults) implements AutoCloseable
    {
        @Override
        public void close() throws NamingException {
            this.searchResults.close();
        }
    }
}

