/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.securityprovider.ldap;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.airlift.log.Logger;
import javax.naming.NamingException;
import org.weakref.jmx.MBeanExporter;
import ru.cedrusdata.catalog.securityprovider.ldap.CatalogLdapPasswordAuthenticator;
import ru.cedrusdata.catalog.securityprovider.ldap.CatalogLdapSecurityProviderConfig;
import ru.cedrusdata.catalog.securityprovider.ldap.CatalogLdapSecurityProviderPlugin;
import ru.cedrusdata.catalog.securityprovider.ldap.client.CatalogLdapClient;
import ru.cedrusdata.catalog.spi.classloader.CatalogThreadContextClassLoader;
import ru.cedrusdata.catalog.spi.security.CatalogPasswordAuthenticator;
import ru.cedrusdata.catalog.spi.security.CatalogSecurityProvider;

public class CatalogLdapSecurityProvider
implements CatalogSecurityProvider {
    private static final Logger log = Logger.get(CatalogLdapSecurityProvider.class);
    private final String providerName;
    private final MBeanExporter mbeanExporter;
    private final CatalogLdapPasswordAuthenticator passwordAuthenticator;
    private final CatalogLdapSecurityProviderConfig config;
    private final CatalogLdapClient client;

    @Inject
    public CatalogLdapSecurityProvider(@Named(value="providerName") String providerName, MBeanExporter mbeanExporter, CatalogLdapPasswordAuthenticator passwordAuthenticator, CatalogLdapSecurityProviderConfig config, CatalogLdapClient client) {
        this.providerName = providerName;
        this.mbeanExporter = mbeanExporter;
        this.passwordAuthenticator = passwordAuthenticator;
        this.config = config;
        this.client = client;
    }

    public CatalogPasswordAuthenticator passwordAuthenticator() {
        return this.passwordAuthenticator;
    }

    public void check() {
        try (CatalogThreadContextClassLoader ignored = new CatalogThreadContextClassLoader(CatalogLdapSecurityProviderPlugin.class.getClassLoader());){
            this.client.processLdapContext(this.config.getBindUser(), this.config.getBindPassword(), results -> true);
        }
        catch (NamingException e) {
            log.error((Throwable)e, "Check error");
            throw new RuntimeException(e);
        }
    }

    public void jmxRegister() {
        this.mbeanExporter.export(String.format("cedrusdata.catalog.plugin.securityprovider.ldap:type=%s,name=%s", CatalogLdapPasswordAuthenticator.class.getSimpleName(), this.providerName), (Object)this.passwordAuthenticator);
    }

    public void close() {
        try {
            this.mbeanExporter.destroy();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Failed to unregister MBeans");
        }
    }
}

