/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.function;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.function.SchemaFunctionName;
import java.util.Locale;
import java.util.Objects;

public final class CatalogSchemaFunctionName {
    private final String catalogName;
    private final SchemaFunctionName schemaFunctionName;

    public CatalogSchemaFunctionName(String catalogName, SchemaFunctionName schemaFunctionName) {
        this.catalogName = catalogName.toLowerCase(Locale.ROOT);
        if (catalogName.isEmpty()) {
            throw new IllegalArgumentException("catalogName is empty");
        }
        this.schemaFunctionName = Objects.requireNonNull(schemaFunctionName, "schemaFunctionName is null");
    }

    @JsonCreator
    public CatalogSchemaFunctionName(@JsonProperty String catalogName, @JsonProperty String schemaName, @JsonProperty String functionName) {
        this(catalogName, new SchemaFunctionName(schemaName, functionName));
    }

    @JsonProperty
    public String getCatalogName() {
        return this.catalogName;
    }

    public SchemaFunctionName getSchemaFunctionName() {
        return this.schemaFunctionName;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaFunctionName.getSchemaName();
    }

    @JsonProperty
    public String getFunctionName() {
        return this.schemaFunctionName.getFunctionName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogSchemaFunctionName that = (CatalogSchemaFunctionName)o;
        return Objects.equals(this.catalogName, that.catalogName) && Objects.equals(this.schemaFunctionName, that.schemaFunctionName);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.schemaFunctionName);
    }

    public String toString() {
        return this.catalogName + "." + String.valueOf(this.schemaFunctionName);
    }
}

