/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.SchemaUtil;
import io.trino.spi.type.Type;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;

public final class ColumnSchema {
    private final String name;
    private final Type type;
    private final boolean hidden;

    private ColumnSchema(String name, Type type, boolean hidden) {
        SchemaUtil.checkNotEmpty(name, "name");
        Objects.requireNonNull(type, "type is null");
        this.name = name.toLowerCase(Locale.ENGLISH);
        this.type = type;
        this.hidden = hidden;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnSchema that = (ColumnSchema)o;
        return this.hidden == that.hidden && this.name.equals(that.name) && this.type.equals(that.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.hidden);
    }

    public String toString() {
        return new StringJoiner(", ", ColumnSchema.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("type=" + String.valueOf(this.type)).add("hidden=" + this.hidden).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ColumnMetadata columnMetadata) {
        return new Builder(columnMetadata);
    }

    public static class Builder {
        private String name;
        private Type type;
        private boolean hidden;

        private Builder() {
        }

        private Builder(ColumnMetadata columnMetadata) {
            this.name = columnMetadata.getName();
            this.type = columnMetadata.getType();
            this.hidden = columnMetadata.isHidden();
        }

        public Builder setName(String name) {
            this.name = Objects.requireNonNull(name, "name is null");
            return this;
        }

        public Builder setType(Type type) {
            this.type = Objects.requireNonNull(type, "type is null");
            return this;
        }

        public Builder setHidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public ColumnSchema build() {
            return new ColumnSchema(this.name, this.type, this.hidden);
        }
    }
}

