/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2;

import io.opentelemetry.instrumentation.awssdk.v2_2.SqsMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.services.sqs.model.Message;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;

final class SqsMessageImpl
implements SqsMessage {
    private final Message message;

    private SqsMessageImpl(Message message) {
        this.message = message;
    }

    static SqsMessage wrap(Message message) {
        return new SqsMessageImpl(message);
    }

    static List<SqsMessage> wrap(List<Message> messages) {
        ArrayList<SqsMessage> result = new ArrayList<SqsMessage>();
        for (Message message : messages) {
            result.add(SqsMessageImpl.wrap(message));
        }
        return result;
    }

    @Override
    public Map<String, MessageAttributeValue> messageAttributes() {
        return this.message.messageAttributes();
    }

    @Override
    public Map<String, String> attributesAsStrings() {
        return this.message.attributesAsStrings();
    }

    @Override
    public String getMessageAttribute(String name) {
        MessageAttributeValue value = (MessageAttributeValue)this.message.messageAttributes().get(name);
        return value != null ? value.stringValue() : null;
    }

    @Override
    public String getMessageId() {
        return this.message.messageId();
    }
}

