/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.local;

import com.google.common.primitives.Ints;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoInputStream;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

class LocalInputStream
extends TrinoInputStream {
    private final Location location;
    private final File file;
    private final long fileLength;
    private InputStream input;
    private long position;
    private boolean closed;

    public LocalInputStream(Location location, File file) throws FileNotFoundException {
        this.location = Objects.requireNonNull(location, "location is null");
        this.file = Objects.requireNonNull(file, "file is null");
        this.fileLength = file.length();
        this.input = new BufferedInputStream(new FileInputStream(file), 4096);
    }

    @Override
    public int available() throws IOException {
        this.ensureOpen();
        return Ints.saturatedCast((long)(this.fileLength - this.position));
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public void seek(long position) throws IOException {
        this.ensureOpen();
        if (position < 0L) {
            throw new IOException("Negative seek offset");
        }
        if (position > this.fileLength) {
            throw new IOException("Cannot seek to %s. File size is %s: %s".formatted(position, this.fileLength, this.location));
        }
        if (position < this.position) {
            this.input.close();
            this.input = new BufferedInputStream(new FileInputStream(this.file), 4096);
            this.position = 0L;
        }
        while (position > this.position) {
            long skip = this.input.skip(position - this.position);
            if (skip < 0L) {
                throw new IOException("Skip returned a negative size");
            }
            if (skip > 0L) {
                this.position += skip;
                continue;
            }
            if (this.input.read() == -1) {
                throw new EOFException();
            }
            ++this.position;
        }
        if (this.position != position) {
            throw new IOException("Seek to %s failed. Current position is %s: %s".formatted(position, this.position, this.location));
        }
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        int read = this.input.read();
        if (read != -1) {
            ++this.position;
        }
        return read;
    }

    @Override
    public int read(byte[] destination, int destinationIndex, int length) throws IOException {
        this.ensureOpen();
        int read = this.input.read(destination, destinationIndex, length);
        if (read > 0) {
            this.position += (long)read;
        }
        return read;
    }

    @Override
    public long skip(long length) throws IOException {
        this.ensureOpen();
        length = Math.clamp(length, 0L, this.fileLength - this.position);
        this.seek(this.position + length);
        return length;
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Output stream closed: " + String.valueOf(this.location));
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.input.close();
        }
    }
}

