/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import ru.cedrusdata.catalog.spi.model.StringValue;

@JsonTypeName(value="SecurityProviderUpdateRequest")
public class SecurityProviderUpdateRequest {
    private final StringValue newProviderName;
    private final StringValue description;
    private final Map<String, String> updatedProperties;
    private final Set<String> removedProperties;

    @JsonCreator
    public SecurityProviderUpdateRequest(@JsonProperty(value="new-provider-name") StringValue newProviderName, @JsonProperty(value="description") StringValue description, @JsonProperty(value="updated-properties") Map<String, String> updatedProperties, @JsonProperty(value="removed-properties") Set<String> removedProperties) {
        this.newProviderName = newProviderName;
        this.description = description;
        this.updatedProperties = updatedProperties;
        this.removedProperties = removedProperties;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="new-provider-name")
    public StringValue getNewProviderName() {
        return this.newProviderName;
    }

    @JsonProperty(value="description")
    public StringValue getDescription() {
        return this.description;
    }

    @JsonProperty(value="updated-properties")
    public Map<String, String> getUpdatedProperties() {
        return this.updatedProperties;
    }

    @JsonProperty(value="removed-properties")
    public Set<String> getRemovedProperties() {
        return this.removedProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityProviderUpdateRequest securityProviderUpdateRequest = (SecurityProviderUpdateRequest)o;
        return Objects.equals(this.newProviderName, securityProviderUpdateRequest.newProviderName) && Objects.equals(this.description, securityProviderUpdateRequest.description) && Objects.equals(this.updatedProperties, securityProviderUpdateRequest.updatedProperties) && Objects.equals(this.removedProperties, securityProviderUpdateRequest.removedProperties);
    }

    public int hashCode() {
        return Objects.hash(this.newProviderName, this.description, this.updatedProperties, this.removedProperties);
    }

    public String toString() {
        return "SecurityProviderUpdateRequest{newProviderName='" + String.valueOf(this.newProviderName) + "', description='" + String.valueOf(this.description) + "', updatedProperties='" + String.valueOf(this.updatedProperties) + "', removedProperties='" + String.valueOf(this.removedProperties) + "'}";
    }

    public static class Builder {
        private StringValue newProviderName;
        private StringValue description;
        private Map<String, String> updatedProperties;
        private Set<String> removedProperties;

        private Builder() {
        }

        public Builder setNewProviderName(StringValue newProviderName) {
            this.newProviderName = newProviderName;
            return this;
        }

        public Builder setDescription(StringValue description) {
            this.description = description;
            return this;
        }

        public Builder setUpdatedProperties(Map<String, String> updatedProperties) {
            this.updatedProperties = updatedProperties;
            return this;
        }

        public Builder setRemovedProperties(Set<String> removedProperties) {
            this.removedProperties = removedProperties;
            return this;
        }

        public SecurityProviderUpdateRequest build() {
            return new SecurityProviderUpdateRequest(this.newProviderName, this.description, this.updatedProperties, this.removedProperties);
        }
    }
}

