/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;

@JsonTypeName(value="SecurableTypeInfo")
public class SecurableTypeInfo {
    private final String securableType;
    private final String parentSecurableType;

    @JsonCreator
    public SecurableTypeInfo(@JsonProperty(value="securable-type") String securableType, @JsonProperty(value="parent-securable-type") String parentSecurableType) {
        this.securableType = securableType;
        this.parentSecurableType = parentSecurableType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="securable-type")
    public String getSecurableType() {
        return this.securableType;
    }

    @JsonProperty(value="parent-securable-type")
    public String getParentSecurableType() {
        return this.parentSecurableType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurableTypeInfo securableTypeInfo = (SecurableTypeInfo)o;
        return Objects.equals(this.securableType, securableTypeInfo.securableType) && Objects.equals(this.parentSecurableType, securableTypeInfo.parentSecurableType);
    }

    public int hashCode() {
        return Objects.hash(this.securableType, this.parentSecurableType);
    }

    public String toString() {
        return "SecurableTypeInfo{securableType='" + this.securableType + "', parentSecurableType='" + this.parentSecurableType + "'}";
    }

    public static class Builder {
        private String securableType;
        private String parentSecurableType;

        private Builder() {
        }

        public Builder setSecurableType(String securableType) {
            this.securableType = securableType;
            return this;
        }

        public Builder setParentSecurableType(String parentSecurableType) {
            this.parentSecurableType = parentSecurableType;
            return this;
        }

        public SecurableTypeInfo build() {
            return new SecurableTypeInfo(this.securableType, this.parentSecurableType);
        }
    }
}

