/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import java.util.UUID;

@JsonTypeName(value="ObjectGroupItemInfo")
public class ObjectGroupItemInfo {
    private final UUID itemId;
    private final String namespaceName;
    private final String objectName;

    @JsonCreator
    public ObjectGroupItemInfo(@JsonProperty(value="item-id") UUID itemId, @JsonProperty(value="namespace-name") String namespaceName, @JsonProperty(value="object-name") String objectName) {
        this.itemId = itemId;
        this.namespaceName = namespaceName;
        this.objectName = objectName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="item-id")
    public UUID getItemId() {
        return this.itemId;
    }

    @JsonProperty(value="namespace-name")
    public String getNamespaceName() {
        return this.namespaceName;
    }

    @JsonProperty(value="object-name")
    public String getObjectName() {
        return this.objectName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectGroupItemInfo objectGroupItemInfo = (ObjectGroupItemInfo)o;
        return Objects.equals(this.itemId, objectGroupItemInfo.itemId) && Objects.equals(this.namespaceName, objectGroupItemInfo.namespaceName) && Objects.equals(this.objectName, objectGroupItemInfo.objectName);
    }

    public int hashCode() {
        return Objects.hash(this.itemId, this.namespaceName, this.objectName);
    }

    public String toString() {
        return "ObjectGroupItemInfo{itemId='" + String.valueOf(this.itemId) + "', namespaceName='" + this.namespaceName + "', objectName='" + this.objectName + "'}";
    }

    public static class Builder {
        private UUID itemId;
        private String namespaceName;
        private String objectName;

        private Builder() {
        }

        public Builder setItemId(UUID itemId) {
            this.itemId = itemId;
            return this;
        }

        public Builder setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder setObjectName(String objectName) {
            this.objectName = objectName;
            return this;
        }

        public ObjectGroupItemInfo build() {
            return new ObjectGroupItemInfo(this.itemId, this.namespaceName, this.objectName);
        }
    }
}

