/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;

@JsonTypeName(value="ObjectGroupItemAddRequest")
public class ObjectGroupItemAddRequest {
    private final String namespaceName;
    private final String objectName;

    @JsonCreator
    public ObjectGroupItemAddRequest(@JsonProperty(value="namespace-name") String namespaceName, @JsonProperty(value="object-name") String objectName) {
        this.namespaceName = namespaceName;
        this.objectName = objectName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="namespace-name")
    public String getNamespaceName() {
        return this.namespaceName;
    }

    @JsonProperty(value="object-name")
    public String getObjectName() {
        return this.objectName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectGroupItemAddRequest objectGroupItemAddRequest = (ObjectGroupItemAddRequest)o;
        return Objects.equals(this.namespaceName, objectGroupItemAddRequest.namespaceName) && Objects.equals(this.objectName, objectGroupItemAddRequest.objectName);
    }

    public int hashCode() {
        return Objects.hash(this.namespaceName, this.objectName);
    }

    public String toString() {
        return "ObjectGroupItemAddRequest{namespaceName='" + this.namespaceName + "', objectName='" + this.objectName + "'}";
    }

    public static class Builder {
        private String namespaceName;
        private String objectName;

        private Builder() {
        }

        public Builder setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder setObjectName(String objectName) {
            this.objectName = objectName;
            return this;
        }

        public ObjectGroupItemAddRequest build() {
            return new ObjectGroupItemAddRequest(this.namespaceName, this.objectName);
        }
    }
}

